/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.client.keymappings;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.keymappings.KeyConflictContext;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.balm.api.client.keymappings.KeyModifiers;
import net.blay09.mods.balm.mixin.KeyMappingAccessor;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class CommonBalmKeyMappings
implements BalmKeyMappings {
    private final Set<class_304> ignoreConflicts = Sets.newConcurrentHashSet();
    private final Map<class_304, Set<class_304>> multiModifierKeyMappings = new ConcurrentHashMap<class_304, Set<class_304>>();

    @Override
    public class_304 registerKeyMapping(String name, int keyCode, String category) {
        return this.registerKeyMapping(name, KeyConflictContext.UNIVERSAL, KeyModifier.NONE, class_3675.class_307.field_1668, keyCode, category);
    }

    @Override
    public class_304 registerKeyMapping(String name, class_3675.class_307 type, int keyCode, String category) {
        return this.registerKeyMapping(name, KeyConflictContext.UNIVERSAL, KeyModifier.NONE, type, keyCode, category);
    }

    @Override
    public class_304 registerKeyMapping(String name, KeyConflictContext conflictContext, KeyModifier modifier, int keyCode, String category) {
        return this.registerKeyMapping(name, conflictContext, modifier, class_3675.class_307.field_1668, keyCode, category);
    }

    @Override
    public class_304 registerKeyMapping(String name, KeyConflictContext conflictContext, KeyModifiers modifiers, int keyCode, String category) {
        return this.registerKeyMapping(name, conflictContext, modifiers, class_3675.class_307.field_1668, keyCode, category);
    }

    protected void registerModifierKeyMappings(class_304 baseMapping, KeyConflictContext conflictContext, List<KeyModifier> keyModifiers) {
        for (int i = 0; i < keyModifiers.size(); ++i) {
            String subName = i > 0 ? baseMapping.method_1431() + "_modifier_" + i : baseMapping.method_1431() + "_modifier";
            class_304 subKeyMapping = this.registerKeyMapping(subName, conflictContext, KeyModifier.NONE, class_3675.class_307.field_1668, this.toKeyCode(keyModifiers.get(i)), baseMapping.method_1423());
            this.multiModifierKeyMappings.computeIfAbsent(baseMapping, it -> new HashSet()).add(subKeyMapping);
            this.ignoreConflicts.add(subKeyMapping);
        }
    }

    protected void registerCustomModifierKeyMappings(class_304 baseMapping, KeyConflictContext conflictContext, List<class_3675.class_306> keyModifiers) {
        for (int i = 0; i < keyModifiers.size(); ++i) {
            String subName = i > 0 ? baseMapping.method_1431() + "_modifier_" + i : baseMapping.method_1431() + "_modifier";
            class_304 subKeyMapping = this.registerKeyMapping(subName, conflictContext, KeyModifier.NONE, class_3675.class_307.field_1668, keyModifiers.get(i).method_1444(), baseMapping.method_1423());
            this.multiModifierKeyMappings.computeIfAbsent(baseMapping, it -> new HashSet()).add(subKeyMapping);
            this.ignoreConflicts.add(subKeyMapping);
        }
    }

    private int toKeyCode(KeyModifier keyModifier) {
        return switch (keyModifier) {
            case KeyModifier.SHIFT -> 340;
            case KeyModifier.CONTROL -> 341;
            case KeyModifier.ALT -> 342;
            default -> -1;
        };
    }

    protected boolean areModifiersActive(class_304 keyMapping) {
        Set modifierMappings = this.multiModifierKeyMappings.getOrDefault(keyMapping, Collections.emptySet());
        for (class_304 modifierMapping : modifierMappings) {
            if ((modifierMapping.method_1417(340, 0) || modifierMapping.method_1417(344, 0)) && class_437.method_25442() || (modifierMapping.method_1417(341, 0) || modifierMapping.method_1417(345, 0)) && class_437.method_25441() || (modifierMapping.method_1417(342, 0) || modifierMapping.method_1417(346, 0)) && class_437.method_25443() || this.isActiveAndKeyDown(modifierMapping)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isActiveAndKeyDown(@Nullable class_304 keyMapping) {
        if (!this.isActive(keyMapping)) {
            return false;
        }
        class_3675.class_306 key = ((KeyMappingAccessor)keyMapping).getKey();
        return keyMapping.method_1434() || key.method_1444() != -1 && key.method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.method_1444());
    }

    @Override
    public boolean isKeyDownIgnoreContext(@Nullable class_304 keyMapping) {
        if (!this.isActiveIgnoreContext(keyMapping)) {
            return false;
        }
        class_3675.class_306 key = ((KeyMappingAccessor)keyMapping).getKey();
        return keyMapping.method_1434() || key.method_1444() != -1 && key.method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.method_1444());
    }

    @Override
    public boolean isActiveAndWasPressed(@Nullable class_304 keyMapping) {
        return this.isActive(keyMapping) && keyMapping.method_1436();
    }

    @Contract(value="null -> false")
    protected boolean isActive(@Nullable class_304 keyMapping) {
        if (keyMapping == null) {
            return false;
        }
        return this.isContextActive(keyMapping) && this.areModifiersActive(keyMapping);
    }

    @Contract(value="null -> false")
    protected boolean isActiveIgnoreContext(@Nullable class_304 keyMapping) {
        if (keyMapping == null) {
            return false;
        }
        return this.areModifiersActive(keyMapping);
    }

    @Override
    public boolean isActiveAndMatches(@Nullable class_304 keyMapping, class_3675.class_306 input) {
        if (!this.isActive(keyMapping)) {
            return false;
        }
        return input.method_1442() == class_3675.class_307.field_1672 ? keyMapping.method_1433(input.method_1444()) : keyMapping.method_1417(input.method_1442() == class_3675.class_307.field_1668 ? input.method_1444() : class_3675.field_16237.method_1444(), input.method_1442() == class_3675.class_307.field_1671 ? input.method_1444() : class_3675.field_16237.method_1444());
    }

    @Override
    public boolean isActiveAndMatches(@Nullable class_304 keyMapping, int keyCode, int scanCode) {
        return this.isActive(keyMapping) && keyMapping.method_1417(keyCode, scanCode);
    }

    @Override
    public boolean isActiveAndMatches(@Nullable class_304 keyMapping, class_3675.class_307 type, int keyCode, int scanCode) {
        return this.isActive(keyMapping) && (type == class_3675.class_307.field_1672 ? keyMapping.method_1433(keyCode) : keyMapping.method_1417(keyCode, scanCode));
    }

    @Override
    public Optional<Boolean> conflictsWith(class_304 first, class_304 second) {
        if (this.ignoreConflicts.contains(first) || this.ignoreConflicts.contains(second)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Override
    public void ignoreConflicts(class_304 keyMapping) {
        this.ignoreConflicts.add(keyMapping);
        this.ignoreConflicts.addAll(this.multiModifierKeyMappings.getOrDefault(keyMapping, Collections.emptySet()));
    }

    @Override
    public boolean shouldIgnoreConflicts(class_304 keyMapping) {
        return this.ignoreConflicts.contains(keyMapping);
    }

    protected abstract boolean isContextActive(class_304 var1);

    protected boolean isContextActive(KeyConflictContext conflictContext) {
        return switch (conflictContext) {
            case KeyConflictContext.GUI -> {
                if (class_310.method_1551().field_1755 != null) {
                    yield true;
                }
                yield false;
            }
            case KeyConflictContext.INGAME -> {
                if (class_310.method_1551().field_1755 == null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }
}

