/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.google.common.collect.MapMaker;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.p3pp3rf1y.porting_lib.base.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(class_2248 block) {
        this(block, new class_1792.class_1793().method_7889(1));
    }

    public ShulkerBoxItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (flagIn == class_1836.field_41071) {
            CapabilityStorageWrapper.get(stack).flatMap(IStorageWrapper::getContentsUuid).ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + uuid)).method_27692(class_124.field_1063)));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        StorageContentsTooltip ret = null;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310 mc = class_310.method_1551();
            if (class_437.method_25442() || mc.field_1724 != null && !mc.field_1724.field_7512.method_34255().method_7960()) {
                ret = new StorageContentsTooltip(stack);
            }
        }
        return Optional.ofNullable(ret);
    }

    public boolean method_31568() {
        return false;
    }

    public void method_33261(class_1542 itemEntity) {
        class_1937 level = itemEntity.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 itemstack = itemEntity.method_6983();
        CapabilityStorageWrapper.get(itemstack).ifPresent(storageWrapper -> {
            InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getInventoryHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
            InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getUpgradeHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
        });
    }

    public static ItemApiLookup.ItemApiProvider<LazyOptional<StackStorageWrapper>, Void> initCapabilities() {
        return new ItemApiLookup.ItemApiProvider<LazyOptional<StackStorageWrapper>, Void>(){
            final Map<class_1799, StackStorageWrapper> wrapperMap = new MapMaker().weakKeys().weakValues().makeMap();

            public LazyOptional<StackStorageWrapper> find(class_1799 stack, Void context) {
                if (stack.method_7947() == 1) {
                    return LazyOptional.of(() -> this.wrapperMap.computeIfAbsent(stack, this::initWrapper)).cast();
                }
                return LazyOptional.empty();
            }

            private StackStorageWrapper initWrapper(final class_1799 stack) {
                UUID uuid = ShulkerBoxItem.getContentsUuid(stack).orElse(null);
                StackStorageWrapper storageWrapper = new StackStorageWrapper(stack){

                    public String getStorageType() {
                        return "shulker_box";
                    }

                    public class_2561 getDisplayName() {
                        return class_2561.method_43471((String)stack.method_7909().method_7876());
                    }

                    @Override
                    protected boolean isAllowedInStorage(class_1799 stack2) {
                        class_2248 block = class_2248.method_9503((class_1792)stack2.method_7909());
                        return !(block instanceof ShulkerBoxBlock) && !(block instanceof class_2480) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack2.method_7909());
                    }
                };
                if (uuid != null) {
                    class_2487 compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).method_10562("storageWrapper");
                    storageWrapper.load(compoundtag);
                    storageWrapper.setContentsUuid(uuid);
                }
                return storageWrapper;
            }
        };
    }

    private static Optional<UUID> getContentsUuid(class_1799 stack) {
        return NBTHelper.getUniqueId((class_1799)stack, (String)"uuid");
    }

    public Optional<class_5632> getInventoryTooltip(class_1799 stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public class_1799 stash(class_1799 storageStack, class_1799 stack, @Nullable Transaction ctx) {
        return CapabilityStorageWrapper.get(storageStack).map(wrapper -> {
            if (wrapper.getContentsUuid().isEmpty()) {
                wrapper.setContentsUuid(UUID.randomUUID());
            }
            try (Transaction inner = Transaction.openNested((TransactionContext)ctx);){
                long inserted = wrapper.getInventoryForUpgradeProcessing().insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)inner);
                inner.commit();
                class_1799 class_17992 = stack.method_46651(stack.method_7947() - (int)inserted);
                return class_17992;
            }
        }).orElse(stack);
    }

    public IStashStorageItem.StashResult getItemStashable(class_1799 storageStack, class_1799 stack) {
        return CapabilityStorageWrapper.get(storageStack).map(wrapper -> {
            if (StorageUtil.simulateInsert((Storage)wrapper.getInventoryForUpgradeProcessing(), (Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), null) == 0L) {
                return IStashStorageItem.StashResult.NO_SPACE;
            }
            if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.method_7909()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
                return IStashStorageItem.StashResult.MATCH_AND_SPACE;
            }
            return IStashStorageItem.StashResult.SPACE;
        }).orElse(IStashStorageItem.StashResult.NO_SPACE);
    }

    public void setNumberOfInventorySlots(class_1799 shulkerBoxStack, int numberOfInventorySlots) {
        NBTHelper.putInt((class_2487)shulkerBoxStack.method_7948(), (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public int getNumberOfInventorySlots(class_1799 shulkerBoxStack) {
        int defaultNumberOfInventorySlots = CapabilityStorageWrapper.get(shulkerBoxStack).map(StorageWrapper::getDefaultNumberOfInventorySlots).orElse(1);
        return NBTHelper.getInt((class_1799)shulkerBoxStack, (String)"numberOfInventorySlots").map(inventorySlots -> Math.max(inventorySlots, defaultNumberOfInventorySlots)).orElse(defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(class_1799 shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = CapabilityStorageWrapper.get(shulkerBoxStack).map(StorageWrapper::getDefaultNumberOfUpgradeSlots).orElse(1);
        return NBTHelper.getInt((class_1799)shulkerBoxStack, (String)"numberOfUpgradeSlots").map(numberOfUpgradeSlots -> Math.max(numberOfUpgradeSlots, defaultNumberOfUpgradeSlots)).orElse(defaultNumberOfUpgradeSlots);
    }

    public void setNumberOfUpgradeSlots(class_1799 shulkerBoxStack, int numberOfUpgradeSlots) {
        NBTHelper.putInt((class_2487)shulkerBoxStack.method_7948(), (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }

    public boolean method_31565(class_1799 storageStack, class_1735 slot, class_5536 action, class_1657 player) {
        class_1799 stashResult;
        if (storageStack.method_7947() > 1 || !slot.method_7674(player) || slot.method_7677().method_7960() || action != class_5536.field_27014) {
            return super.method_31565(storageStack, slot, action, player);
        }
        class_1799 stackToStash = slot.method_7677();
        try (Transaction simulate = Transaction.openOuter();){
            stashResult = this.stash(storageStack, stackToStash, simulate);
        }
        if (stashResult.method_7947() < stackToStash.method_7947()) {
            int countToTake = stackToStash.method_7947() - stashResult.method_7947();
            class_1799 takeResult = slot.method_32753(countToTake, countToTake, player);
            this.stash(storageStack, takeResult, null);
            return true;
        }
        return super.method_31565(storageStack, slot, action, player);
    }

    public boolean method_31566(class_1799 storageStack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedAccess) {
        if (storageStack.method_7947() > 1 || !slot.method_7680(storageStack) || action != class_5536.field_27014) {
            return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        class_1799 result = this.stash(storageStack, otherStack, null);
        if (result.method_7947() != otherStack.method_7947()) {
            carriedAccess.method_32332(result);
            slot.method_7673(storageStack);
            return true;
        }
        return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
    }
}

