/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.MenuProviderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageContainerMenu
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    private final StorageBlockEntity storageBlockEntity;

    public StorageContainerMenu(int containerId, class_1657 player, class_2338 pos) {
        this(ModBlocks.STORAGE_CONTAINER_TYPE, containerId, player, pos);
    }

    public StorageContainerMenu(class_3917<?> menuType, int containerId, class_1657 player, class_2338 pos) {
        super(menuType, containerId, player, StorageContainerMenu.getWrapper(player.method_37908(), pos), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false);
        this.storageBlockEntity = (StorageBlockEntity)WorldHelper.getBlockEntity((class_1922)player.method_37908(), (class_2338)pos, StorageBlockEntity.class).orElseThrow(() -> new IllegalArgumentException("Incorrect block entity at " + pos + " exptected to find StorageBlockEntity"));
        this.storageBlockEntity.startOpen(player);
    }

    public StorageBlockEntity getStorageBlockEntity() {
        return this.storageBlockEntity;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.storageBlockEntity.stopOpen(player);
    }

    private static IStorageWrapper getWrapper(class_1937 level, class_2338 pos) {
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).map(be -> be.getStorageWrapper()).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
    }

    public static StorageContainerMenu fromBuffer(int windowId, class_1661 playerInventory, class_2540 packetBuffer) {
        return new StorageContainerMenu(windowId, playerInventory.field_7546, packetBuffer.method_10811());
    }

    public Optional<class_2338> getBlockPosition() {
        return Optional.of(this.storageBlockEntity.method_11016());
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (StorageContainerMenu.this.player.method_37908().method_8608()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)StorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.method_10582("action", "openSettings"));
            return;
        }
        this.getBlockPosition().ifPresent(pos -> this.player.method_17355((class_3908)MenuProviderHelper.createMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, (class_2338)pos), buffer -> buffer.method_10807(pos), (class_2561)class_2561.method_43471((String)StorageTranslationHelper.INSTANCE.translGui("settings.title")))));
    }

    protected StorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, class_1657 player, class_2338 pos) {
        return new StorageSettingsContainerMenu(windowId, player, pos);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        return false;
    }

    public boolean method_7597(class_1657 player) {
        WoodStorageBlockEntity woodStorageBlockEntity;
        class_2338 pos = this.storageBlockEntity.method_11016();
        class_2586 be = player.method_37908().method_8321(pos);
        return be instanceof StorageBlockEntity && player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0 && (!(be instanceof WoodStorageBlockEntity) || !(woodStorageBlockEntity = (WoodStorageBlockEntity)be).isPacked());
    }

    protected void onStorageInventorySlotSet(int slotIndex) {
        MemorySettingsCategory memorySettings;
        super.onStorageInventorySlotSet(slotIndex);
        if (this.getStorageBlockEntity().isLocked() && this.getStorageBlockEntity().memorizesItemsWhenLocked() && !this.method_7611(slotIndex).method_7677().method_7960() && !(memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).isSlotSelected(slotIndex)) {
            memorySettings.selectSlot(slotIndex);
        }
    }

    public float getSlotFillPercentage(int slot) {
        return this.storageBlockEntity.getSlotFillPercentage(slot);
    }
}

