/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlotItemHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class DecorationTableMenu
extends class_1703
implements ISyncedContainer {
    private static final String SET_INHERITANCE_ACTION = "setInheritance";
    private static final class_2960 EMPTY_RED_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_red_dye_slot");
    private static final class_2960 EMPTY_GREEN_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_green_dye_slot");
    private static final class_2960 EMPTY_BLUE_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_blue_dye_slot");
    private static final class_2960 EMPTY_MATERIAL_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_material_slot");
    public static final int DECORATION_SLOT_PADDING = 12;
    private final DecorationTableBlockEntity blockEntity;
    private class_1735 resultSlot;
    private SlotRange decorationSlotRange;
    private SlotRange dyeSlotRange;
    private SlotRange storageSlotRange;
    private SlotRange playerSlotRange;

    public DecorationTableMenu(int containerId, class_1657 player, class_2338 pos) {
        super(ModBlocks.DECORATION_TABLE_CONTAINER_TYPE, containerId);
        this.blockEntity = player.method_37908().method_35230(pos, ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE).orElse(null);
        if (this.blockEntity == null) {
            throw new IllegalStateException("No block entity found at position " + pos);
        }
        int y = this.addDecorationSlots();
        this.addStorageSlots();
        this.addPlayerSlots(player.method_31548(), y += 14);
    }

    private void addStorageSlots() {
        ItemStackHandler storageBlock = this.blockEntity.getStorageBlock();
        SlotItemHandler storageSlot = new SlotItemHandler((SlottedStackStorage)storageBlock, 0, this.method_7611((int)this.dyeSlotRange.firstSlot()).field_7873, this.method_7611((int)3).field_7872);
        this.method_7621((class_1735)storageSlot);
        this.storageSlotRange = new SlotRange(this.dyeSlotRange.firstSlot() + this.dyeSlotRange.numberOfSlots(), 1);
        this.resultSlot = new class_1735((class_1263)new class_1277(1){

            public class_1799 method_5438(int index) {
                return DecorationTableMenu.this.blockEntity.getResult();
            }

            public class_1799 method_5434(int index, int count) {
                return index == 0 ? DecorationTableMenu.this.blockEntity.extractResult(count) : class_1799.field_8037;
            }
        }, 0, storageSlot.field_7873 + 18 + 18, storageSlot.field_7872){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 player) {
                return super.method_7674(player) && DecorationTableMenu.this.getMissingDyes().isEmpty();
            }

            public class_1799 method_7671(int amount) {
                return super.method_7671(amount);
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                super.method_7667(player, stack);
                if (player.method_37908().method_8608()) {
                    return;
                }
                DecorationTableMenu.this.blockEntity.consumeIngredientsOnCraft();
                try (Transaction ctx = Transaction.openOuter();){
                    DecorationTableMenu.this.blockEntity.getStorageBlock().extractSlot(0, DecorationTableMenu.this.blockEntity.getStorageBlock().getVariantInSlot(0), 1L, (TransactionContext)ctx);
                    ctx.commit();
                }
            }
        };
        this.method_7621(this.resultSlot);
    }

    private int addDecorationSlots() {
        int xOffset = 8;
        int yOffset = 17;
        ItemStackHandler decorativeBlocks = this.blockEntity.getDecorativeBlocks();
        int x = xOffset;
        int y = yOffset;
        int slotIndex = 0;
        y = this.addDecorationSlot(decorativeBlocks, slotIndex, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 1, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 2, x, y, 12);
        this.addDecorationSlot(decorativeBlocks, 3, x, y, 12);
        y = yOffset + 18 + 12;
        y = this.addDecorationSlot(decorativeBlocks, 4, x += 48, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 5, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 6, x, y, 0);
        this.decorationSlotRange = new SlotRange(0, decorativeBlocks.getSlotCount());
        ItemStackHandler dyes = this.blockEntity.getDyes();
        this.method_7621(new SlotItemHandler((SlottedStackStorage)dyes, 0, x += 44, yOffset).setBackground(class_1723.field_21668, EMPTY_RED_DYE_SLOT_BACKGROUND));
        this.method_7621(new SlotItemHandler((SlottedStackStorage)dyes, 1, x += 18, yOffset).setBackground(class_1723.field_21668, EMPTY_GREEN_DYE_SLOT_BACKGROUND));
        this.method_7621(new SlotItemHandler((SlottedStackStorage)dyes, 2, x += 18, yOffset).setBackground(class_1723.field_21668, EMPTY_BLUE_DYE_SLOT_BACKGROUND));
        this.dyeSlotRange = new SlotRange(this.decorationSlotRange.firstSlot() + this.decorationSlotRange.numberOfSlots(), dyes.getSlotCount());
        return y;
    }

    private int addDecorationSlot(ItemStackHandler itemHandler, int slotIndex, int xOffset, int y, int yPadding) {
        this.method_7621(new SlotItemHandler((SlottedStackStorage)itemHandler, slotIndex, xOffset, y).setBackground(class_1723.field_21668, EMPTY_MATERIAL_SLOT_BACKGROUND));
        y += 18;
        return y += yPadding;
    }

    private void addPlayerSlots(class_1661 playerInventory, int y) {
        int playerSlotXOffset = 45;
        int hotbarPadding = 4;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, playerSlotXOffset + col * 18, y + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            class_1735 slot = new class_1735((class_1263)playerInventory, col, playerSlotXOffset + col * 18, y + 54 + hotbarPadding);
            this.method_7621(slot);
        }
        this.playerSlotRange = new SlotRange(this.storageSlotRange.firstSlot() + this.storageSlotRange.numberOfSlots() + 1, 36);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot = this.method_7611(slotIndex);
        class_1799 slotStack = slot.method_7677();
        class_1799 slotStackCopy = slotStack.method_7972();
        if (this.isPlayerSlot(slotIndex)) {
            if (this.blockEntity.getDecorativeBlocks().isItemValid(this.decorationSlotRange.firstSlot(), ItemVariant.of((class_1799)slotStack), slotStack.method_7947()) && !this.moveItemStackTo(slotStack, this.decorationSlotRange, false)) {
                return class_1799.field_8037;
            }
            if (this.isValidDye(slotStack) && !this.moveItemStackTo(slotStack, this.dyeSlotRange, false)) {
                return class_1799.field_8037;
            }
            if (this.blockEntity.getStorageBlock().isItemValid(0, ItemVariant.of((class_1799)slotStack), slotStack.method_7947()) && !this.moveItemStackTo(slotStack, this.storageSlotRange, false)) {
                return class_1799.field_8037;
            }
        } else if (!this.moveItemStackTo(slotStack, this.playerSlotRange, true)) {
            return class_1799.field_8037;
        }
        if (slotStackCopy.method_7947() == slotStack.method_7947()) {
            return class_1799.field_8037;
        }
        this.blockEntity.updateResultAndSetChanged();
        slot.method_7667(player, slotStackCopy);
        return slotStackCopy;
    }

    private boolean isValidDye(class_1799 stack) {
        ItemStackHandler dyes = this.blockEntity.getDyes();
        for (int slot = 0; slot < dyes.getSlotCount(); ++slot) {
            if (!dyes.isItemValid(slot, ItemVariant.of((class_1799)stack), stack.method_7947())) continue;
            return true;
        }
        return false;
    }

    private boolean moveItemStackTo(class_1799 stack, SlotRange slotRange, boolean reverse) {
        return this.method_7616(stack, slotRange.firstSlot(), slotRange.firstSlot() + slotRange.numberOfSlots(), reverse);
    }

    private boolean isPlayerSlot(int slotIndex) {
        return this.playerSlotRange.isInRange(slotIndex);
    }

    public SlotRange getDyeSlotRange() {
        return this.dyeSlotRange;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_5649((double)this.blockEntity.method_11016().method_10263() + 0.5, (double)this.blockEntity.method_11016().method_10264() + 0.5, (double)this.blockEntity.method_11016().method_10260() + 0.5) <= 64.0;
    }

    public static DecorationTableMenu fromBuffer(int containerId, class_1661 playerInventory, class_2540 buffer) {
        return new DecorationTableMenu(containerId, playerInventory.field_7546, buffer.method_10811());
    }

    public void setSlotMaterialInheritance(int slot, boolean inheritance) {
        this.blockEntity.setSlotMaterialInheritance(slot, inheritance);
        this.sendToServer(tag -> {
            tag.method_10582("action", SET_INHERITANCE_ACTION);
            tag.method_10569("slot", slot);
            tag.method_10556("inheritance", inheritance);
        });
    }

    public void setMainColor(int color) {
        this.blockEntity.setMainColor(color);
        this.sendToServer(tag -> tag.method_10569("mainColor", color));
    }

    public void setAccentColor(int color) {
        this.blockEntity.setAccentColor(color);
        this.sendToServer(tag -> tag.method_10569("accentColor", color));
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.blockEntity.isSlotMaterialInherited(slot);
    }

    public class_1799 getInheritedItem(int childSlot) {
        return this.blockEntity.getInheritedItem(childSlot);
    }

    public int getMainColor() {
        return this.blockEntity.getMainColor();
    }

    public int getAccentColor() {
        return this.blockEntity.getAccentColor();
    }

    public class_1735 getResultSlot() {
        return this.resultSlot;
    }

    protected void sendToServer(Consumer<class_2487> addData) {
        if (this.blockEntity.method_10997() == null || !this.blockEntity.method_10997().field_9236) {
            return;
        }
        class_2487 data = new class_2487();
        addData.accept(data);
        PacketHandler.sendToServer((Object)new SyncContainerClientDataMessage(data));
    }

    public Map<class_2960, Integer> getPartsNeeded() {
        return this.blockEntity.getPartsNeeded();
    }

    public Set<class_2960> getMissingDyes() {
        return this.blockEntity.getMissingDyes();
    }

    public void handleMessage(class_2487 data) {
        String action = data.method_10558("action");
        if (action.equals(SET_INHERITANCE_ACTION)) {
            this.setSlotMaterialInheritance(data.method_10550("slot"), data.method_10577("inheritance"));
        } else if (data.method_10545("mainColor")) {
            this.setMainColor(data.method_10550("mainColor"));
        } else if (data.method_10545("accentColor")) {
            this.setAccentColor(data.method_10550("accentColor"));
        }
    }

    public Map<class_2960, Integer> getPartsStored() {
        return this.blockEntity.getPartsStored();
    }
}

