/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.init;

import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.mixin.client.accessor.MinecraftAccessor;
import org.apache.commons.lang3.ArrayUtils;

public class ModBlockColors {
    private ModBlockColors() {
    }

    public static void registerBlockColorHandlers() {
        ColorProviderRegistry.BLOCK.register(ModBlockColors::getBarrelTintColor, (Object[])ModBlocks.ALL_BARRELS);
        ColorProviderRegistry.BLOCK.register(ModBlockColors::getChestShulkerBoxColor, (Object[])((class_2248[])ArrayUtils.addAll((Object[])ModBlocks.CHESTS, (Object[])ModBlocks.SHULKER_BOXES)));
    }

    private static int getBarrelTintColor(class_2680 state, @Nullable class_1920 blockDisplayReader, @Nullable class_2338 pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((class_1922)blockDisplayReader, (class_2338)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 1000) {
                return be.getStorageWrapper().getMainColor();
            }
            if (tintIndex == 1001) {
                return be.getStorageWrapper().getAccentColor();
            }
            RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
            int displayItemIndex = (tintIndex > 1000 ? tintIndex - 1000 : tintIndex) / 10 - 1;
            List displayItems = itemDisplayRenderInfo.getDisplayItems();
            if (displayItemIndex >= 0) {
                int tintOffset = (displayItemIndex + 1) * 10;
                class_1799 stack = ModBlockColors.getDisplayItemWithIndex(displayItemIndex, displayItems, state.method_26204() instanceof LimitedBarrelBlock);
                if (stack.method_7960()) {
                    return -1;
                }
                return ((MinecraftAccessor)class_310.method_1551()).getItemColors().method_1704(stack, tintIndex - tintOffset);
            }
            return -1;
        }).orElse(-1);
    }

    private static class_1799 getDisplayItemWithIndex(int displayItemIndex, List<RenderInfo.DisplayItem> displayItems, boolean isLimitedBarrel) {
        if (isLimitedBarrel) {
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                if (displayItem.getSlotIndex() != displayItemIndex) continue;
                return displayItem.getItem();
            }
        }
        return displayItems.size() > displayItemIndex ? displayItems.get(displayItemIndex).getItem() : class_1799.field_8037;
    }

    private static int getChestShulkerBoxColor(class_2680 state, @Nullable class_1920 blockDisplayReader, @Nullable class_2338 pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((class_1922)blockDisplayReader, (class_2338)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            return -1;
        }).orElse(-1);
    }
}

