/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Map<class_4719, class_5794> CUSTOM_TEXTURE_WOOD_TYPES = ImmutableMap.builder().put((Object)class_4719.field_21679, (Object)class_5793.field_28500).put((Object)class_4719.field_21678, (Object)class_5793.field_28501).put((Object)class_4719.field_22183, (Object)class_5793.field_28502).put((Object)class_4719.field_21681, (Object)class_5793.field_28505).put((Object)class_4719.field_21680, (Object)class_5793.field_28503).put((Object)class_4719.field_21676, (Object)class_5793.field_28504).put((Object)class_4719.field_21677, (Object)class_5793.field_28506).put((Object)class_4719.field_22184, (Object)class_5793.field_28507).put((Object)class_4719.field_37657, (Object)class_5793.field_38007).put((Object)class_4719.field_42837, (Object)class_5793.field_42942).put((Object)class_4719.field_40350, (Object)class_5793.field_40589).build();

    protected WoodStorageBlockBase(class_4970.class_2251 properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void addNameWoodAndTintData(class_1799 stack, class_1922 level, class_2338 pos) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(be -> this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)be));
    }

    @Override
    public void addDropData(class_1799 stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked() || WoodStorageBlockBase.shouldNonEmptyDropPacked(wbe)) {
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                class_2487 storageContents = wbe.getStorageContentsTag();
                if (!storageContents.method_33133()) {
                    ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                    NBTHelper.setUniqueId((class_1799)stack, (String)"uuid", (UUID)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
                StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
                WoodStorageBlockItem.setNumberOfInventorySlots(stack, storageWrapper.getInventoryHandler().getSlotCount());
                WoodStorageBlockItem.setNumberOfUpgradeSlots(stack, storageWrapper.getUpgradeHandler().getSlotCount());
            }
        }
    }

    private static boolean shouldNonEmptyDropPacked(WoodStorageBlockEntity wbe) {
        if (Boolean.FALSE.equals(Config.COMMON.dropPacked.get())) {
            return false;
        }
        return !InventoryHelper.isEmpty((SlottedStackStorage)wbe.getStorageWrapper().getInventoryHandler()) || !InventoryHelper.isEmpty((SlottedStackStorage)wbe.getStorageWrapper().getUpgradeHandler());
    }

    private void addNameWoodAndTintData(class_1799 stack, WoodStorageBlockEntity wbe) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor > -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) > -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        if (wbe.method_16914()) {
            stack.method_7977(wbe.method_5797());
        }
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    @Override
    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        if (!Config.CLIENT_SPEC.isLoaded() || Boolean.TRUE.equals(Config.CLIENT.showSingleWoodVariantOnly.get())) {
            itemConsumer.accept(WoodStorageBlockItem.setWoodType(new class_1799((class_1935)this), class_4719.field_21679));
        } else {
            CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> itemConsumer.accept(WoodStorageBlockItem.setWoodType(new class_1799((class_1935)this), woodType)));
        }
        if (this.isBasicTier() || Boolean.TRUE.equals(!Config.CLIENT_SPEC.isLoaded() || (Boolean)Config.CLIENT.showHigherTierTintedVariants.get() != false)) {
            for (class_1767 color : class_1767.values()) {
                class_1799 storageStack = new class_1799((class_1935)this);
                class_1792 class_17922 = storageStack.method_7909();
                if (class_17922 instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
                    tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
                    tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
                }
                itemConsumer.accept(storageStack);
            }
            class_1799 storageStack = new class_1799((class_1935)this);
            class_1792 class_17923 = storageStack.method_7909();
            if (class_17923 instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17923;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7947.method_7787()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7961.method_7787()));
            }
            itemConsumer.accept(storageStack);
        }
    }

    private boolean isBasicTier() {
        return this == ModBlocks.BARREL || this == ModBlocks.CHEST || this == ModBlocks.LIMITED_BARREL_1 || this == ModBlocks.LIMITED_BARREL_2 || this == ModBlocks.LIMITED_BARREL_3 || this == ModBlocks.LIMITED_BARREL_4;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = new class_1799((class_1935)this);
        this.addNameWoodAndTintData(stack, world, pos);
        return stack;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((class_1799)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.setBeingUpgraded(true);
                be.method_11014(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.method_7938()) {
                be.setCustomName(stack.method_7964());
            }
            this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.method_6079().method_7909() == ModItems.STORAGE_TOOL) {
                StorageToolItem.useOffHandOnPlaced(placer.method_6079(), be);
            }
            be.setBeingUpgraded(false);
        });
    }

    protected void setRenderBlockRenderProperties(class_1799 stack, WoodStorageBlockEntity be) {
        WoodStorageBlockItem.getWoodType(stack).ifPresent(be::setWoodType);
        StorageBlockItem.getMainColorFromStack(stack).ifPresent(be.getStorageWrapper()::setMainColor);
        StorageBlockItem.getAccentColorFromStack(stack).ifPresent(be.getStorageWrapper()::setAccentColor);
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(level, pos, state, player);
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                wbe.setPacked(true);
                if (!(!player.method_7337() || InventoryHelper.isEmpty((SlottedStackStorage)wbe.getStorageWrapper().getInventoryHandler()) && InventoryHelper.isEmpty((SlottedStackStorage)wbe.getStorageWrapper().getUpgradeHandler()))) {
                    class_1799 drop = new class_1799((class_1935)this);
                    this.addDropData(drop, (StorageBlockEntity)wbe);
                    class_1542 itementity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, drop);
                    itementity.method_6988();
                    level.method_8649((class_1297)itementity);
                }
            }
        });
    }

    protected boolean tryItemInteraction(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand, class_2350 facing, class_3965 hitResult) {
        if (stackInHand.method_7909() == ModItems.PACKING_TAPE) {
            if (Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.sophisticatedstorage.status.packing_tape_disabled"), true);
            } else {
                this.packStorage(player, hand, b, stackInHand);
            }
            return true;
        }
        return this.tryAddUpgrade(player, hand, b, stackInHand, facing, hitResult);
    }

    protected void packStorage(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand) {
        class_2680 blockState;
        class_2248 class_22482;
        if (!player.method_7337()) {
            stackInHand.method_7974(stackInHand.method_7919() + 1);
            if (stackInHand.method_7919() >= stackInHand.method_7936()) {
                player.method_6122(hand, class_1799.field_8037);
            }
        }
        if ((class_22482 = (blockState = b.method_11010()).method_26204()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            if (((Boolean)blockState.method_11654((class_2769)StorageBlockBase.TICKING)).booleanValue()) {
                storageBlock.setTicking(player.method_37908(), b.method_11016(), blockState, false);
            }
        }
        b.setPacked(true);
        b.removeFromController();
        WorldHelper.notifyBlockUpdate((class_2586)b);
    }
}

