/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;

public abstract class StorageWrapper
implements IStorageWrapper {
    private static final String MAIN_COLOR_TAG = "mainColor";
    private static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String UUID_TAG = "uuid";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    public static final String CONTENTS_TAG = "contents";
    private final Supplier<Runnable> getSaveHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    private class_2487 contentsNbt = new class_2487();
    private class_2487 settingsNbt = new class_2487();
    private final SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private class_2487 renderInfoNbt = new class_2487();
    @Nullable
    protected UUID contentsUuid = null;
    private int openTabId = -1;
    protected int numberOfInventorySlots = 0;
    protected int numberOfUpgradeSlots = -1;
    private SortBy sortBy = SortBy.NAME;
    private int columnsTaken = 0;
    private int mainColor = -1;
    private int accentColor = -1;
    private Runnable upgradeCachesInvalidatedHandler = () -> {};
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, Runnable onSerializeRenderInfo, Runnable markContentsDirty) {
        this(getSaveHandler, onSerializeRenderInfo, markContentsDirty, 1);
    }

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, final Runnable onSerializeRenderInfo, Runnable markContentsDirty, final int numberOfDisplayItems) {
        this.getSaveHandler = getSaveHandler;
        this.renderInfo = new RenderInfo(getSaveHandler){

            protected void serializeRenderInfo(class_2487 renderInfo) {
                StorageWrapper.this.renderInfoNbt = renderInfo;
                onSerializeRenderInfo.run();
            }

            protected Optional<class_2487> getRenderInfoTag() {
                return Optional.of(StorageWrapper.this.renderInfoNbt);
            }
        };
        this.settingsHandler = new StorageSettingsHandler(this.settingsNbt, markContentsDirty, this::getInventoryHandler, () -> this.renderInfo){

            @Override
            protected int getNumberOfDisplayItems() {
                return numberOfDisplayItems;
            }
        };
    }

    public void setContentsUuid(@Nullable UUID contentsUuid) {
        this.contentsUuid = contentsUuid;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                this.upgradeCachesInvalidatedHandler.run();
            }){

                public boolean isItemValid(int slot, ItemVariant resource, int count) {
                    return super.isItemValid(slot, resource, count) && (resource.isBlank() || "sophisticatedstorage".equals(class_7923.field_41178.method_10221((Object)resource.getItem()).method_12836()) || resource.toStack(count).method_31573(ModItems.STORAGE_UPGRADE_TAG));
                }

                public void refreshUpgradeWrappers() {
                    super.refreshUpgradeWrappers();
                    StorageWrapper.this.onUpgradeRefresh();
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    protected abstract void onUpgradeRefresh();

    public class_2487 save(class_2487 tag) {
        this.saveContents(tag);
        this.saveData(tag);
        return tag;
    }

    private void saveContents(class_2487 tag) {
        tag.method_10566(CONTENTS_TAG, (class_2520)this.getContentsNbt().method_10553());
    }

    class_2487 saveData(class_2487 tag) {
        if (!this.settingsNbt.method_33133()) {
            tag.method_10566("settings", (class_2520)this.settingsNbt);
        }
        if (!this.renderInfoNbt.method_33133()) {
            tag.method_10566("renderInfo", (class_2520)this.renderInfoNbt);
        }
        if (this.contentsUuid != null) {
            tag.method_10566(UUID_TAG, (class_2520)class_2512.method_25929((UUID)this.contentsUuid));
        }
        if (this.openTabId >= 0) {
            tag.method_10569(OPEN_TAB_ID_TAG, this.openTabId);
        }
        tag.method_10582("sortBy", this.sortBy.method_15434());
        if (this.columnsTaken > 0) {
            tag.method_10569("columnsTaken", this.columnsTaken);
        }
        if (this.numberOfInventorySlots > 0) {
            tag.method_10569("numberOfInventorySlots", this.numberOfInventorySlots);
        }
        if (this.numberOfUpgradeSlots > -1) {
            tag.method_10569("numberOfUpgradeSlots", this.numberOfUpgradeSlots);
        }
        if (this.mainColor > -1) {
            tag.method_10569(MAIN_COLOR_TAG, this.mainColor);
        }
        if (this.accentColor > -1) {
            tag.method_10569(ACCENT_COLOR_TAG, this.accentColor);
        }
        return tag;
    }

    public void load(class_2487 tag) {
        this.loadContents(tag);
        this.loadData(tag);
        this.initInventoryHandler();
        this.getUpgradeHandler().refreshUpgradeWrappers();
        if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && this.getRenderInfo().getUpgradeItems().size() != this.getUpgradeHandler().getSlotCount()) {
            this.getUpgradeHandler().setRenderUpgradeItems();
        }
    }

    private void loadData(class_2487 tag) {
        this.settingsNbt = tag.method_10562("settings");
        this.settingsHandler.reloadFrom(this.settingsNbt);
        this.renderInfoNbt = tag.method_10562("renderInfo");
        this.renderInfo.deserializeFrom(this.renderInfoNbt);
        this.contentsUuid = NBTHelper.getTagValue((class_2487)tag, (String)UUID_TAG, class_2487::method_10580).map(class_2512::method_25930).orElse(null);
        this.openTabId = NBTHelper.getInt((class_2487)tag, (String)OPEN_TAB_ID_TAG).orElse(-1);
        this.sortBy = NBTHelper.getString((class_2487)tag, (String)"sortBy").map(SortBy::fromName).orElse(SortBy.NAME);
        this.columnsTaken = NBTHelper.getInt((class_2487)tag, (String)"columnsTaken").orElse(0);
        this.loadSlotNumbers(tag);
        this.mainColor = NBTHelper.getInt((class_2487)tag, (String)MAIN_COLOR_TAG).orElse(-1);
        this.accentColor = NBTHelper.getInt((class_2487)tag, (String)ACCENT_COLOR_TAG).orElse(-1);
    }

    protected void loadSlotNumbers(class_2487 tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((class_2487)tag, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((class_2487)tag, (String)"numberOfUpgradeSlots").orElse(-1);
    }

    private void loadContents(class_2487 tag) {
        if (tag.method_10545(CONTENTS_TAG)) {
            this.contentsNbt = tag.method_10562(CONTENTS_TAG);
            this.onContentsNbtUpdated();
        }
    }

    public void setSaveHandler(Runnable saveHandler) {
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(ItemVariant resource) {
                return StorageWrapper.this.isAllowedInStorage(resource.toStack());
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
    }

    protected boolean emptyInventorySlotsAcceptItems() {
        return true;
    }

    protected class_2487 getContentsNbt() {
        return this.contentsNbt;
    }

    public int getNumberOfInventorySlots() {
        if (this.numberOfInventorySlots > 0) {
            return this.numberOfInventorySlots;
        }
        this.numberOfInventorySlots = this.getDefaultNumberOfInventorySlots();
        this.save();
        return this.numberOfInventorySlots;
    }

    protected void save() {
        this.getSaveHandler.get().run();
    }

    public abstract int getDefaultNumberOfInventorySlots();

    protected abstract boolean isAllowedInStorage(class_1799 var1);

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    private int getNumberOfUpgradeSlots() {
        if (this.numberOfUpgradeSlots > -1) {
            return this.numberOfUpgradeSlots;
        }
        this.numberOfUpgradeSlots = this.getDefaultNumberOfUpgradeSlots();
        this.save();
        return this.numberOfUpgradeSlots;
    }

    public abstract int getDefaultNumberOfUpgradeSlots();

    public int getMainColor() {
        return this.mainColor;
    }

    public boolean hasMainColor() {
        return this.mainColor > -1;
    }

    public void setMainColor(int mainColor) {
        this.mainColor = mainColor;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public boolean hasAccentColor() {
        return this.accentColor > -1;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
    }

    public Optional<Integer> getOpenTabId() {
        return this.openTabId >= 0 ? Optional.of(this.openTabId) : Optional.empty();
    }

    public void setOpenTabId(int openTabId) {
        this.openTabId = openTabId;
        this.save();
    }

    public void removeOpenTabId() {
        this.openTabId = -1;
        this.save();
    }

    public void setColors(int mainColor, int accentColor) {
        this.mainColor = mainColor;
        this.accentColor = accentColor;
        this.save();
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
        this.save();
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((SlottedStackStorage)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(class_1657 playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        this.columnsTaken = columnsTaken;
        this.save();
    }

    public int getColumnsTaken() {
        return this.columnsTaken;
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.numberOfInventorySlots += additionalInventorySlots;
        this.getInventoryHandler().changeSlots(additionalInventorySlots);
        this.numberOfUpgradeSlots += additionalUpgradeSlots;
        this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }
}

