/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.p3pp3rf1y.porting_lib.base.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageIOBlockEntity
extends class_2586
implements IControllerBoundable,
ILinkable {
    @Nullable
    private class_2338 controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean chunkBeingUnloaded = false;
    private Map<BlockApiLookup<?, class_2350>, Map<class_2350, LazyOptional<?>>> capabilitySideCache = new HashMap();

    protected StorageIOBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> this.onChunkUnloaded());
    }

    public StorageIOBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlocks.STORAGE_IO_BLOCK_ENTITY_TYPE, pos, state);
    }

    public Set<class_2338> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public void setControllerPos(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.invalidateAllCapabilityCache();
        this.method_5431();
    }

    public Optional<class_2338> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void linkToController(class_2338 controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.method_5431();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.removeControllerPos();
        this.method_5431();
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.invalidateAllCapabilityCache();
        this.capabilitySideCache.clear();
        this.method_5431();
    }

    private void invalidateAllCapabilityCache() {
        this.capabilitySideCache.forEach((cap, map) -> {
            HashMap<class_2350, LazyOptional> copy = new HashMap<class_2350, LazyOptional>((Map<class_2350, LazyOptional>)map);
            copy.forEach((side, lazyOptional) -> lazyOptional.invalidate());
        });
    }

    public class_2338 getStorageBlockPos() {
        return this.method_11016();
    }

    public class_1937 getStorageBlockLevel() {
        return this.method_10997();
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void addToController(class_1937 level, class_2338 pos, class_2338 controllerPos) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public boolean canBeConnected() {
        return this.isLinked() || this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.method_11016());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public void removeFromController() {
        if (!this.field_11863.method_8608()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((class_1922)this.field_11863, (class_2338)p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeNonConnectingBlock(this.method_11016()));
            this.removeControllerPos();
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.method_10556("isLinkedToController", this.isLinkedToController);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((class_2487)tag, (String)"isLinkedToController").orElse(false);
    }

    public <T> LazyOptional<T> getCapability(BlockApiLookup<T, class_2350> cap, @Nullable class_2350 opt) {
        if (this.getControllerPos().isEmpty()) {
            return LazyOptional.empty();
        }
        if (!this.capabilitySideCache.containsKey(cap) || !this.capabilitySideCache.get(cap).containsKey(opt)) {
            LazyOptional lazyOptional = this.getControllerPos().flatMap(p -> WorldHelper.getLoadedBlockEntity((class_1937)this.method_10997(), (class_2338)p, ControllerBlockEntity.class)).map(c -> this.getControllerCapability(cap, opt, (ControllerBlockEntity)c)).orElseGet(LazyOptional::empty);
            this.capabilitySideCache.computeIfAbsent(cap, k -> new HashMap()).put(opt, lazyOptional);
            if (lazyOptional.isPresent()) {
                lazyOptional.addListener(l -> this.removeCapabilityCacheOnSide(cap, opt));
            }
        }
        return this.capabilitySideCache.get(cap).get(opt).cast();
    }

    private <T> void removeCapabilityCacheOnSide(BlockApiLookup<T, class_2350> cap, @Nullable class_2350 side) {
        if (this.capabilitySideCache.containsKey(cap) && this.capabilitySideCache.get(cap).containsKey(side)) {
            this.capabilitySideCache.get(cap).get(side).invalidate();
            this.capabilitySideCache.get(cap).remove(side);
        }
    }

    @Nullable
    protected <T> LazyOptional<T> getControllerCapability(BlockApiLookup<T, class_2350> cap, @Nullable class_2350 opt, ControllerBlockEntity c) {
        return c.getCapability(cap, opt);
    }

    public void onChunkUnloaded() {
        this.chunkBeingUnloaded = true;
    }

    public void method_11012() {
        if (!this.chunkBeingUnloaded && this.field_11863 != null) {
            this.unlinkFromController();
        }
        super.method_11012();
    }
}

