/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.api.network.MessageDirection;
import com.mrcrayfish.framework.api.util.EnvironmentHelper;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.framework.platform.network.FabricClientNetworkHandler;
import com.mrcrayfish.framework.platform.network.FabricHandshakeMessage;
import com.mrcrayfish.framework.platform.network.FabricMessage;
import com.mrcrayfish.framework.platform.network.FabricServerNetworkHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;

public class FabricNetwork
implements FrameworkNetwork {
    final class_2960 id;
    final int protocolVersion;
    final Map<Class<?>, FabricMessage<?>> classToPlayMessage;
    final Map<Integer, FabricMessage<?>> indexToPlayMessage;
    final Map<Class<?>, FabricHandshakeMessage<?>> classToHandshakeMessage;
    final Map<Integer, FabricHandshakeMessage<?>> indexToHandshakeMessage;
    private MinecraftServer server;
    private boolean active = false;

    public FabricNetwork(class_2960 id, int protocolVersion, List<FabricMessage<?>> playMessages, List<FabricHandshakeMessage<?>> handshakeMessages) {
        this.id = id;
        this.protocolVersion = protocolVersion;
        this.classToPlayMessage = FabricNetwork.createClassMap(playMessages);
        this.indexToPlayMessage = FabricNetwork.createIndexMap(playMessages);
        this.classToHandshakeMessage = FabricNetwork.createClassMap(handshakeMessages);
        this.indexToHandshakeMessage = FabricNetwork.createIndexMap(handshakeMessages);
        this.setup();
    }

    private void setup() {
        if (!this.classToPlayMessage.isEmpty()) {
            EnvironmentHelper.runOn(Environment.CLIENT, () -> () -> ClientPlayNetworking.registerGlobalReceiver((class_2960)this.id, (client, handler, buf, responseSender) -> FabricClientNetworkHandler.receivePlay(this, client, handler, buf, responseSender)));
            ServerPlayNetworking.registerGlobalReceiver((class_2960)this.id, (server, player, handler, buf, responseSender) -> FabricServerNetworkHandler.receivePlay(this, server, player, handler, buf, responseSender));
        }
        if (!this.classToHandshakeMessage.isEmpty()) {
            EnvironmentHelper.runOn(Environment.CLIENT, () -> () -> ClientLoginNetworking.registerGlobalReceiver((class_2960)this.id, (client, handler, buf, responseSender) -> CompletableFuture.completedFuture(FabricClientNetworkHandler.receiveHandshake(this, client, handler, buf, responseSender))));
            ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> this.sendHandshakeMessages(synchronizer, server, sender, handler.field_14158.method_10756()));
            ServerLoginNetworking.registerGlobalReceiver((class_2960)this.id, (server, handler, understood, buf, synchronizer, responseSender) -> FabricServerNetworkHandler.receiveHandshake(this, server, handler, understood, buf, synchronizer, responseSender));
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.server = null;
        });
        EnvironmentHelper.runOn(Environment.CLIENT, () -> () -> {
            C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
                this.active = channels.contains(this.id);
            });
            C2SPlayChannelEvents.UNREGISTER.register((handler, sender, client, channels) -> {
                if (channels.contains(this.id)) {
                    this.active = false;
                }
            });
        });
        EnvironmentHelper.runOn(Environment.DEDICATED_SERVER, () -> () -> {
            S2CPlayChannelEvents.REGISTER.register((handler, sender, server, channels) -> {
                this.active = channels.contains(this.id);
            });
            S2CPlayChannelEvents.UNREGISTER.register((handler, sender, server, channels) -> {
                if (channels.contains(this.id)) {
                    this.active = false;
                }
            });
        });
    }

    @Override
    public void sendToPlayer(Supplier<class_3222> supplier, IMessage<?> message) {
        class_2540 buf = this.encode(message);
        ServerPlayNetworking.send((class_3222)supplier.get(), (class_2960)this.id, (class_2540)buf);
    }

    @Override
    public void sendToTracking(Supplier<class_1297> supplier, IMessage<?> message) {
        this.sendToTrackingEntity(supplier, message);
    }

    @Override
    public void sendToTrackingEntity(Supplier<class_1297> supplier, IMessage<?> message) {
        class_1297 entity = supplier.get();
        class_2540 buf = this.encode(message);
        class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)this.id, (class_2540)buf);
        ((class_3215)entity.method_5770().method_8398()).method_18754(entity, packet);
    }

    @Override
    public void sendToTrackingBlockEntity(Supplier<class_2586> supplier, IMessage<?> message) {
        this.sendToTrackingChunk(() -> {
            class_2586 entity = (class_2586)supplier.get();
            return Objects.requireNonNull(entity.method_10997()).method_8500(entity.method_11016());
        }, message);
    }

    @Override
    public void sendToTrackingLocation(Supplier<LevelLocation> supplier, IMessage<?> message) {
        this.sendToTrackingChunk(() -> {
            LevelLocation location = (LevelLocation)supplier.get();
            class_243 pos = location.pos();
            int chunkX = class_4076.method_42615((double)pos.field_1352);
            int chunkZ = class_4076.method_42615((double)pos.field_1350);
            return location.level().method_8497(chunkX, chunkZ);
        }, message);
    }

    @Override
    public void sendToTrackingChunk(Supplier<class_2818> supplier, IMessage<?> message) {
        class_2818 chunk = supplier.get();
        class_2540 buf = this.encode(message);
        class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)this.id, (class_2540)buf);
        ((class_3215)chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(e -> e.field_13987.method_14364(packet));
    }

    @Override
    public void sendToNearbyPlayers(Supplier<LevelLocation> supplier, IMessage<?> message) {
        LevelLocation location = supplier.get();
        class_1937 level = location.level();
        class_243 pos = location.pos();
        class_2540 buf = this.encode(message);
        class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)this.id, (class_2540)buf);
        this.server.method_3760().method_14605(null, pos.field_1352, pos.field_1351, pos.field_1350, location.range(), level.method_27983(), packet);
    }

    @Override
    public void sendToServer(IMessage<?> message) {
        class_2540 buf = this.encode(message);
        ClientPlayNetworking.send((class_2960)this.id, (class_2540)buf);
    }

    @Override
    public void sendToAll(IMessage<?> message) {
        class_2540 buf = this.encode(message);
        class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)this.id, (class_2540)buf);
        this.server.method_3760().method_14581(packet);
    }

    @Override
    public boolean isActive(class_2535 connection) {
        return connection.method_10758() && this.active;
    }

    private class_2540 encode(IMessage<?> message) {
        FabricMessage<?> fabricMessage = this.classToPlayMessage.get(message.getClass());
        Preconditions.checkNotNull(fabricMessage);
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(fabricMessage.getIndex());
        fabricMessage.encode(message, buf);
        return buf;
    }

    private void sendHandshakeMessages(ServerLoginNetworking.LoginSynchronizer synchronizer, MinecraftServer server, PacketSender sender, boolean isLocal) {
        this.classToHandshakeMessage.values().forEach(fabricMessage -> Optional.ofNullable(fabricMessage.getMessages()).ifPresent(messages -> ((List)messages.apply(isLocal)).forEach(pair -> synchronizer.waitFor((Future)server.method_20493(() -> {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(fabricMessage.getIndex());
            this.encodeLoginMessage(pair.getValue(), buf);
            sender.sendPacket(this.id, buf);
        })))));
    }

    private <T> void encodeLoginMessage(T message, class_2540 buf) {
        FabricHandshakeMessage<?> msg = this.classToHandshakeMessage.get(message.getClass());
        msg.encode(message, buf);
    }

    private static <T extends FabricMessage<?>> Map<Class<?>, T> createClassMap(Collection<T> c) {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        c.forEach(arg_0 -> FabricNetwork.lambda$createClassMap$26((Object2ObjectMap)map, arg_0));
        return Collections.unmodifiableMap(map);
    }

    private static <T extends FabricMessage<?>> Map<Integer, T> createIndexMap(Collection<T> c) {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        c.forEach(arg_0 -> FabricNetwork.lambda$createIndexMap$27((Int2ObjectMap)map, arg_0));
        return Collections.unmodifiableMap(map);
    }

    static boolean validateMessage(@Nullable FabricMessage<?> message, class_2535 connection) {
        if (message == null) {
            connection.method_10747((class_2561)class_2561.method_43470((String)"Received invalid packet, closing connection"));
            return false;
        }
        MessageDirection direction = message.getDirection();
        if (direction != null && !direction.isClient()) {
            connection.method_10747((class_2561)class_2561.method_43470((String)"Received invalid packet, closing connection"));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$createIndexMap$27(Int2ObjectMap map, FabricMessage msg) {
        map.put(msg.getIndex(), (Object)msg);
    }

    private static /* synthetic */ void lambda$createClassMap$26(Object2ObjectMap map, FabricMessage msg) {
        map.put(msg.getMessageClass(), (Object)msg);
    }
}

