/*
 * Decompiled with CFR 0.152.
 */
package me.steven.bodiesbodies.entity;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import me.steven.bodiesbodies.BodiesBodies;
import me.steven.bodiesbodies.Config;
import me.steven.bodiesbodies.data.DeadBodyData;
import me.steven.bodiesbodies.data.DeadBodyDataProvider;
import me.steven.bodiesbodies.data.VanillaDeadBodyData;
import me.steven.bodiesbodies.data.persistentstate.DeathData;
import me.steven.bodiesbodies.data.persistentstate.DeathHistory;
import me.steven.bodiesbodies.screen.VanillaDeadBodyInventoryScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4050;

public class DeadBodyEntity
extends class_1297 {
    public static final class_2940<class_2487> INVENTORY_DATA = class_2945.method_12791(DeadBodyEntity.class, (class_2941)class_2943.field_13318);
    public static final class_2940<Optional<UUID>> PLAYER_UUID = class_2945.method_12791(DeadBodyEntity.class, (class_2941)class_2943.field_13313);
    private int deathDataId;
    private int emptyTimer = 0;

    public DeadBodyEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_6011.method_12784(PLAYER_UUID, Optional.empty());
        this.field_6011.method_12784(INVENTORY_DATA, (Object)new class_2487());
        this.field_23807 = false;
        this.method_18380(class_4050.field_18078);
    }

    public void method_5773() {
        DeathData deathData;
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        class_3218 world = (class_3218)this.method_37908();
        if (Config.CONFIG.nonEmptyBodyDisappearAfter > 0 && this.field_6012 > Config.CONFIG.nonEmptyBodyDisappearAfter) {
            this.method_31472();
        }
        if ((deathData = this.getDeathData(world)) != null) {
            for (DeadBodyData data : deathData.savedData()) {
                if (data.isEmpty()) continue;
                return;
            }
        }
        ++this.emptyTimer;
        if (Config.CONFIG.emptyBodyDisappearAfter > 0 && this.emptyTimer > Config.CONFIG.emptyBodyDisappearAfter) {
            this.method_31472();
        }
    }

    public DeathData getDeathData(class_3218 world) {
        return DeathHistory.getState(world).getDeathData(this.getPlayerUUID(), this.deathDataId);
    }

    public boolean method_5863() {
        return true;
    }

    public static DeadBodyEntity create(class_3222 player) {
        DeathHistory history = DeathHistory.getState(player.method_51469());
        int id = history.backup(player);
        System.out.println("Player " + String.valueOf(player) + " died. Death ID: " + id);
        DeadBodyEntity deadBody = new DeadBodyEntity(BodiesBodies.DEAD_BODY_ENTITY_TYPE, player.method_37908());
        deadBody.method_23327(player.method_23317(), player.method_23318(), player.method_23321());
        deadBody.field_6011.method_12778(PLAYER_UUID, Optional.of(player.method_5667()));
        ArrayList<DeadBodyData> savedData = new ArrayList<DeadBodyData>(DeadBodyDataProvider.init((class_1657)player));
        class_2487 nbt = new class_2487();
        for (DeadBodyData data : savedData) {
            nbt.method_10566(data.getId(), (class_2520)data.write(new class_2487()));
        }
        deadBody.field_6011.method_12778(INVENTORY_DATA, (Object)nbt);
        deadBody.method_22862();
        deadBody.method_23311();
        deadBody.deathDataId = history.save(id, player, deadBody.method_24515(), savedData);
        return deadBody;
    }

    public UUID getPlayerUUID() {
        return (UUID)((Optional)this.field_6011.method_12789(PLAYER_UUID)).get();
    }

    protected class_238 method_33332() {
        class_238 box = super.method_33332();
        return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324).method_1002(0.0, 1.2, 0.0).method_1009(0.6, 0.0, 0.1);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (Config.CONFIG.bodyAccessibleByAnyoneAfter > 0 && this.field_6012 < Config.CONFIG.bodyAccessibleByAnyoneAfter && ((Optional)this.field_6011.method_12789(PLAYER_UUID)).isPresent() && !player.method_5667().equals(((Optional)this.field_6011.method_12789(PLAYER_UUID)).get())) {
            player.method_43496((class_2561)class_2561.method_43470((String)"This body does not belong to you!"));
            return class_1269.field_5811;
        }
        final class_3218 world = (class_3218)player.method_37908();
        final DeathData deathData = this.getDeathData(world);
        if (player.method_5715()) {
            for (DeadBodyData data : deathData.savedData()) {
                data.transferTo((class_1309)player);
            }
        } else {
            for (DeadBodyData data : deathData.savedData()) {
                if (!(data instanceof VanillaDeadBodyData)) continue;
                final VanillaDeadBodyData vanillaDeadBodyData = (VanillaDeadBodyData)data;
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                        buf.writeInt(deathData.id());
                        buf.method_10794(deathData.writeNbt());
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_43470((String)"Dead body");
                    }

                    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                        return new VanillaDeadBodyInventoryScreenHandler(syncId, playerInventory, DeadBodyEntity.this.getDeathData(world), vanillaDeadBodyData);
                    }
                });
            }
        }
        return class_1269.field_5812;
    }

    public Optional<UUID> getPlayerUuid() {
        return (Optional)this.field_6011.method_12789(PLAYER_UUID);
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6011.method_12778(PLAYER_UUID, Optional.of(nbt.method_25926("PlayerUUID")));
        this.deathDataId = nbt.method_10550("DeathDataId");
        class_3218 world = (class_3218)this.method_37908();
        DeathData deathData = this.getDeathData(world);
        if (deathData != null) {
            class_2487 newNbt = new class_2487();
            for (DeadBodyData data : deathData.savedData()) {
                newNbt.method_10566(data.getId(), (class_2520)data.write(new class_2487()));
            }
            this.field_6011.method_12778(INVENTORY_DATA, (Object)newNbt);
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("DeathDataId", this.deathDataId);
        nbt.method_25927("PlayerUUID", (UUID)((Optional)this.field_6011.method_12789(PLAYER_UUID)).orElse(null));
    }
}

