/*
 * Decompiled with CFR 0.152.
 */
package me.steven.bodiesbodies;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.steven.bodiesbodies.BodiesBodiesCommands;
import me.steven.bodiesbodies.Config;
import me.steven.bodiesbodies.compat.TrinketCompat;
import me.steven.bodiesbodies.data.DeadBodyData;
import me.steven.bodiesbodies.data.DeadBodyDataProvider;
import me.steven.bodiesbodies.data.VanillaDeadBodyData;
import me.steven.bodiesbodies.data.persistentstate.DeathData;
import me.steven.bodiesbodies.data.persistentstate.DeathHistory;
import me.steven.bodiesbodies.entity.DeadBodyEntity;
import me.steven.bodiesbodies.screen.VanillaDeadBodyInventoryScreenHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BodiesBodies
implements ModInitializer {
    public static final class_1299<DeadBodyEntity> DEAD_BODY_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960("bodiesbodies", "dead_body"), (Object)class_1299.class_1300.method_5903(DeadBodyEntity::new, (class_1311)class_1311.field_17715).method_17687(0.6f, 1.8f).method_5905("dead_body"));
    public static final class_3917<VanillaDeadBodyInventoryScreenHandler> VANILLA_DEAD_BODY_SH = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960("bodiesbodies", "vanilla_dead_body"), (Object)new ExtendedScreenHandlerType((syncId, inventory, buf) -> {
        int id = buf.readInt();
        DeathData deathData = DeathData.readNbt(buf.method_10798());
        for (DeadBodyData data : deathData.savedData()) {
            if (!(data instanceof VanillaDeadBodyData)) continue;
            VanillaDeadBodyData vanillaDeadBodyData = (VanillaDeadBodyData)data;
            return new VanillaDeadBodyInventoryScreenHandler(syncId, inventory, deathData, vanillaDeadBodyData);
        }
        return null;
    }));
    public static final class_2960 TRANSFER_ALL_ITEMS_PACKET = new class_2960("bodiesbodies", "transfer_all");
    public static final class_2960 OPEN_DEAD_BODY_INV = new class_2960("bodiesbodies", "open_inv");
    public static final class_2960 OPEN_DEATH_HISTORY = new class_2960("bodiesbodies", "death_history");

    public void onInitialize() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "bodiesbodies.json");
        try {
            if (!file.exists()) {
                file.createNewFile();
                Files.writeString(file.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)Config.CONFIG), new OpenOption[0]);
            } else {
                Config.CONFIG = (Config)new GsonBuilder().create().fromJson(Files.readString(file.toPath(), Charset.defaultCharset()), Config.class);
            }
        }
        catch (IOException e) {
            Config.CONFIG = new Config();
            System.out.println("Error while loading Bodies! Bodies! config, loading default");
        }
        DeadBodyDataProvider.register(VanillaDeadBodyData::new);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TRANSFER_ALL_ITEMS_PACKET, (server, player, handler, buf, responseSender) -> {
            int deathId = buf.readInt();
            server.execute(() -> {
                DeathData deathData = DeathHistory.getState(player.method_51469()).getDeathData(player.method_5667(), deathId);
                if (deathData != null) {
                    for (DeadBodyData data : deathData.savedData()) {
                        data.transferTo((class_1309)player);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OPEN_DEAD_BODY_INV, (server, player, handler, buf, responseSender) -> {
            final int deathId = buf.readInt();
            String invId = buf.method_19772();
            server.execute(() -> {
                final DeathData deathData = DeathHistory.getState(player.method_51469()).getDeathData(player.method_5667(), deathId);
                if (deathData != null) {
                    for (final DeadBodyData data : deathData.savedData()) {
                        if (!data.getId().equals(invId)) continue;
                        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                                buf.writeInt(deathId);
                                buf.method_10794(deathData.writeNbt());
                            }

                            public class_2561 method_5476() {
                                return class_2561.method_43470((String)"Dead body");
                            }

                            @Nullable
                            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                                return data.createMenu(syncId, playerInventory, player, deathData);
                            }
                        });
                    }
                }
            });
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            DeathHistory purged;
            class_3218 world = server.method_30002();
            DeathHistory data = DeathHistory.getState(world);
            int purgedCount = data.purgeOldEntries(purged = (DeathHistory)world.method_17983().method_17924(nbt -> DeathHistory.readNbt(world, nbt), () -> new DeathHistory(world), "death_history_purged"));
            if (purgedCount > 0) {
                purged.method_80();
            }
        });
        BodiesBodiesCommands.registerCommands();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketCompat.load();
        }
    }

    public static void createDeadBody(class_3222 player) {
        DeadBodyEntity deadBodyEntity = DeadBodyEntity.create(player);
        player.method_37908().method_8649((class_1297)deadBodyEntity);
    }
}

