/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.io.nbt.JMChunkLoader;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.task.multi.BaseMapTask;
import journeymap.client.task.multi.ITask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3551;
import net.minecraft.class_3977;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

public class MapRegionTask
extends BaseMapTask {
    private static final int MAX_RUNTIME = 30000;
    private static final Logger logger = Journeymap.getLogger();
    private static volatile long lastTaskCompleted;
    public static MapType MAP_TYPE;
    public static boolean active;
    final PolygonOverlay regionOverlay;
    final RegionCoord rCoord;
    final Collection<class_1923> retainedCoords;

    private MapRegionTask(ChunkRenderController renderController, class_1937 world, MapType mapType, RegionCoord rCoord, Collection<class_1923> chunkCoords, Collection<class_1923> retainCoords) {
        super(renderController, world, mapType, chunkCoords, true, false, 5000);
        this.rCoord = rCoord;
        this.retainedCoords = retainCoords;
        this.regionOverlay = this.createOverlay();
    }

    public static BaseMapTask create(ChunkRenderController renderController, RegionCoord rCoord, MapType mapType, class_310 minecraft) {
        class_638 world = minecraft.field_1687;
        List<class_1923> renderCoords = rCoord.getChunkCoordsInRegion();
        ArrayList<class_1923> retainedCoords = new ArrayList<class_1923>(renderCoords.size());
        HashMap<RegionCoord, Boolean> existingRegions = new HashMap<RegionCoord, Boolean>();
        for (class_1923 coord : renderCoords) {
            for (class_1923 keepAliveOffset : keepAliveOffsets) {
                class_1923 keepAliveCoord = new class_1923(coord.field_9181 + keepAliveOffset.field_9181, coord.field_9180 + keepAliveOffset.field_9180);
                RegionCoord neighborRCoord = RegionCoord.fromChunkPos(rCoord.worldDir, mapType, keepAliveCoord.field_9181, keepAliveCoord.field_9180);
                if (!existingRegions.containsKey(neighborRCoord)) {
                    existingRegions.put(neighborRCoord, neighborRCoord.exists());
                }
                if (renderCoords.contains(keepAliveCoord) || !((Boolean)existingRegions.get(neighborRCoord)).booleanValue()) continue;
                retainedCoords.add(keepAliveCoord);
            }
        }
        return new MapRegionTask(renderController, (class_1937)world, mapType, rCoord, renderCoords, retainedCoords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void performTask(class_310 mc, JourneymapClient jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        block14: {
            if (!active) {
                return;
            }
            ClientAPI.INSTANCE.show((Displayable)this.regionOverlay);
            try (class_3977 loader = new class_3977(new File(FileHandler.getWorldSaveDir(mc), "region").toPath(), class_3551.method_15450(), true);){
                String label;
                ChunkMD chunkMD;
                int missing = 0;
                HashSet<ChunkMD> chuckSet = new HashSet<ChunkMD>();
                for (class_1923 coord : this.retainedCoords) {
                    chunkMD = JMChunkLoader.getChunkMD(loader, mc, coord, true);
                    if (chunkMD == null || !chunkMD.hasChunk()) continue;
                    chuckSet.add(chunkMD);
                }
                for (class_1923 coord : this.chunkCoords) {
                    chunkMD = JMChunkLoader.getChunkMD(loader, mc, coord, true);
                    if (chunkMD != null && chunkMD.hasChunk()) {
                        chuckSet.add(chunkMD);
                        continue;
                    }
                    ++missing;
                }
                if (this.chunkCoords.size() - missing > 0) {
                    try {
                        chuckSet.forEach(DataCache.INSTANCE::addChunkMD);
                        logger.info(String.format("Potential chunks to map in %s: %s of %s", this.rCoord, this.chunkCoords.size() - missing, this.chunkCoords.size()));
                        super.performTask(mc, jm, jmWorldDir, threadLogging);
                        chuckSet.forEach(DataCache.INSTANCE::removeChunkMD);
                        chuckSet.clear();
                    }
                    catch (Throwable throwable) {
                        this.regionOverlay.getShapeProperties().setFillColor(0xFFFFFF).setFillOpacity(0.15f).setStrokeColor(0xFFFFFF);
                        String label2 = String.format("%s\nRegion [%s,%s]", Constants.getString("jm.common.automap_region_complete"), this.rCoord.regionX, this.rCoord.regionZ);
                        this.regionOverlay.setLabel(label2);
                        this.regionOverlay.flagForRerender();
                        throw throwable;
                    }
                    this.regionOverlay.getShapeProperties().setFillColor(0xFFFFFF).setFillOpacity(0.15f).setStrokeColor(0xFFFFFF);
                    label = String.format("%s\nRegion [%s,%s]", Constants.getString("jm.common.automap_region_complete"), this.rCoord.regionX, this.rCoord.regionZ);
                    this.regionOverlay.setLabel(label);
                    this.regionOverlay.flagForRerender();
                    break block14;
                }
                this.regionOverlay.getShapeProperties().setFillColor(0xFF0000).setFillOpacity(0.15f).setStrokeColor(0xFF0000);
                label = String.format("%s\nRegion [%s,%s]", Constants.getString("jm.common.automap_region_complete"), this.rCoord.regionX, this.rCoord.regionZ);
                this.regionOverlay.setLabel(label);
                this.regionOverlay.flagForRerender();
                chuckSet.clear();
                logger.info(String.format("Skipping empty region: %s", this.rCoord));
            }
            catch (IOException e) {
                logger.error("Failed closing loader", (Throwable)e);
            }
        }
    }

    protected PolygonOverlay createOverlay() {
        String displayId = "AutoMap" + this.rCoord;
        String groupName = "AutoMap";
        String label = String.format("%s\nRegion [%s,%s]", Constants.getString("jm.common.automap_region_start"), this.rCoord.regionX, this.rCoord.regionZ);
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(255).setStrokeOpacity(0.7f).setFillColor(65280).setFillOpacity(0.2f);
        TextProperties textProps = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setFontShadow(true);
        int x = this.rCoord.getMinChunkX() << 4;
        int y = 70;
        int z = this.rCoord.getMinChunkZ() << 4;
        int maxX = (this.rCoord.getMaxChunkX() << 4) + 15;
        int maxZ = (this.rCoord.getMaxChunkZ() << 4) + 15;
        class_2338 sw = new class_2338(x, y, maxZ);
        class_2338 se = new class_2338(maxX, y, maxZ);
        class_2338 ne = new class_2338(maxX, y, z);
        class_2338 nw = new class_2338(x, y, z);
        MapPolygon polygon = new MapPolygon(new class_2338[]{sw, se, ne, nw});
        PolygonOverlay regionOverlay = new PolygonOverlay("journeymap", displayId, this.rCoord.dimension, shapeProps, polygon);
        regionOverlay.setOverlayGroupName(groupName).setLabel(label).setTextProperties(textProps).setActiveUIs(EnumSet.of(Context.UI.Fullscreen, Context.UI.Webmap)).setActiveMapTypes(EnumSet.of(Context.MapType.Any));
        return regionOverlay;
    }

    @Override
    protected void complete(int mappedChunks, boolean cancelled, boolean hadError) {
        lastTaskCompleted = System.currentTimeMillis();
        RegionImageCache.INSTANCE.flushToDiskAsync(true);
        DataCache.INSTANCE.stopChunkMDRetention();
        if (hadError || cancelled) {
            logger.warn("MapRegionTask cancelled {} hadError {}}", (Object)cancelled, (Object)hadError);
        } else {
            logger.info(String.format("Actual chunks mapped in %s: %s ", this.rCoord, mappedChunks));
            this.regionOverlay.setTitle(Constants.getString("jm.common.automap_region_chunks", mappedChunks));
        }
        long usedPct = MapRegionTask.getMemoryUsage();
        if (usedPct >= 85L) {
            logger.warn(String.format("Memory usage at %2d%%, forcing garbage collection", usedPct));
            System.gc();
            usedPct = MapRegionTask.getMemoryUsage();
        }
        logger.info(String.format("Memory usage at %2d%%", usedPct));
    }

    public static long getMemoryUsage() {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return (total - free) * 100L / max;
    }

    @Override
    public int getMaxRuntime() {
        return 30000;
    }

    static {
        active = false;
    }

    public static class Manager
    implements ITaskManager {
        final int mapTaskDelay = 0;
        RegionLoader regionLoader;
        boolean enabled;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return MapRegionTask.class;
        }

        @Override
        public boolean enableTask(class_310 minecraft, Object params) {
            EntityDTO player = DataCache.getPlayer();
            boolean cavesAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
            boolean underground = player.underground;
            if (underground && !cavesAllowed) {
                logger.info("Cave mapping not permitted.");
                return false;
            }
            boolean bl = this.enabled = params != null;
            if (!this.enabled) {
                return false;
            }
            if (System.currentTimeMillis() - lastTaskCompleted < (long)JourneymapClient.getInstance().getCoreProperties().autoMapPoll.get().intValue()) {
                return false;
            }
            this.enabled = false;
            if (minecraft.method_1542()) {
                try {
                    MapType mapType = MAP_TYPE;
                    if (mapType == null) {
                        mapType = Fullscreen.state().getMapType();
                    }
                    Boolean mapAll = params == null ? false : (Boolean)params;
                    active = true;
                    this.regionLoader = new RegionLoader(minecraft, mapType, mapAll);
                    if (this.regionLoader.getRegionsFound() == 0) {
                        this.disableTask(minecraft);
                    } else {
                        this.enabled = true;
                    }
                }
                catch (Throwable t) {
                    String error = "Couldn't Auto-Map: " + t.getMessage();
                    ChatLog.announceError(error);
                    logger.error(error + ": " + LogFormatter.toString(t));
                }
            }
            return this.enabled;
        }

        @Override
        public boolean isEnabled(class_310 minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(class_310 minecraft) {
            if (this.regionLoader != null) {
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_complete_underground", this.regionLoader.getVSlice());
                } else {
                    ChatLog.announceI18N("jm.common.automap_complete", new Object[0]);
                }
            }
            this.enabled = false;
            active = false;
            if (this.regionLoader != null) {
                RegionImageCache.INSTANCE.flushToDisk(true);
                RegionImageCache.INSTANCE.clear();
                DataCache.INSTANCE.invalidateChunkMDCache();
                this.regionLoader.getRegions().clear();
                this.regionLoader = null;
            }
            RegionDataStorageHandler.getInstance().flushDataCache();
            ClientAPI.INSTANCE.removeAll("journeymap", DisplayType.Polygon);
        }

        @Override
        public BaseMapTask getTask(class_310 minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (this.regionLoader == null || this.regionLoader.getRegions() == null || this.regionLoader.getRegions().isEmpty()) {
                this.disableTask(minecraft);
                return null;
            }
            RegionCoord rCoord = this.regionLoader.getRegions().peek();
            ChunkRenderController chunkRenderController = JourneymapClient.getInstance().getChunkRenderController();
            BaseMapTask baseMapTask = MapRegionTask.create(chunkRenderController, rCoord, this.regionLoader.getMapType(), minecraft);
            return baseMapTask;
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
            if (accepted) {
                this.regionLoader.getRegions().pop();
                float total = 1.0f * (float)this.regionLoader.getRegionsFound();
                float remaining = total - (float)this.regionLoader.getRegions().size();
                String percent = new DecimalFormat("##.#").format(remaining * 100.0f / total) + "%";
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_status_underground", this.regionLoader.getVSlice(), percent);
                } else {
                    ChatLog.announceI18N("jm.common.automap_status", percent);
                }
            }
        }
    }
}

