/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.mod.IBlockSpritesProxy;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.ui.GuiHooks;
import journeymap.common.Journeymap;
import journeymap.common.accessors.FluidAccess;
import journeymap.common.log.LogFormatter;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Logger;

public class VanillaBlockSpriteProxy
implements IBlockSpritesProxy,
FluidAccess {
    private static Logger logger = Journeymap.getLogger();
    class_773 bms = class_310.method_1551().method_1541().method_3351();

    @Override
    @Nullable
    public Collection<ColoredSprite> getSprites(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        class_2680 blockState = blockMD.getBlockState();
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2404) {
            class_3609 fluidBlock = this.getFluid(block);
            class_1058 tas = FluidRenderHandlerRegistry.INSTANCE.get(fluidBlock.method_15750()).getFluidSprites(null, null, fluidBlock.method_15785())[0];
            return Collections.singletonList(new ColoredSprite(tas, null));
        }
        if (blockState.method_28501().contains(class_2320.field_10929)) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
        }
        HashMap<String, ColoredSprite> map = new HashMap<String, ColoredSprite>();
        try {
            class_1087 model = this.bms.method_3335(blockState);
            block2: for (class_2680 state : new class_2680[]{blockState, null}) {
                for (class_2350 facing : new class_2350[]{class_2350.field_11036, null}) {
                    if (this.getSprites(blockMD, model, state, facing, map, chunkMD, blockPos)) break block2;
                }
            }
            if (map.isEmpty()) {
                class_1058 defaultSprite = this.bms.method_3339(blockState);
                if (defaultSprite != null) {
                    map.put(defaultSprite.method_45851().method_45816().method_12832(), new ColoredSprite(defaultSprite, null));
                    if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                        logger.debug(String.format("Resorted to using BlockModelStates.getTexture() to use %s as color for %s", defaultSprite.method_45851().method_45816().method_12832(), blockState));
                    }
                } else {
                    logger.warn(String.format("Unable to get any texture to use as color for %s", blockState));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error during getSprites(): " + class_7923.field_41175.method_10221((Object)blockMD.getBlock()) + " - " + LogFormatter.toPartialString(e));
        }
        return map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSprites(BlockMD blockMD, class_1087 model, @Nullable class_2680 blockState, @Nullable class_2350 facing, HashMap<String, ColoredSprite> map, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        class_1921 originalType = GuiHooks.getRenderType();
        if (blockPos != null && chunkMD != null && chunkMD.getWorld() != null) {
            try {
                blockState = chunkMD.getWorld().method_8320(blockPos);
                model = this.bms.method_3335(blockState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean success = false;
        try {
            for (class_1921 type : class_1921.method_22720()) {
                if (!class_2464.field_11458.equals((Object)blockMD.getBlockState().method_26217())) continue;
                GuiHooks.setRenderType(type);
                List quads = model.method_4707(blockState, facing, class_5819.method_43047());
                if (!this.addSprites(map, quads)) continue;
                if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                    logger.debug(String.format("Success during [%s] %s.getQuads(%s, %s, %s)", type, model.getClass(), blockState, facing, 0));
                }
                success = true;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error(String.format("Error during [%s] %s.getQuads(%s, %s, %s): %s", GuiHooks.getRenderType(), model.getClass(), blockState, facing, 0, LogFormatter.toPartialString(e)));
            }
        }
        finally {
            GuiHooks.setRenderType(originalType);
        }
        return success;
    }

    public boolean addSprites(HashMap<String, ColoredSprite> sprites, List<class_777> quads) {
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        if (quads.size() > 1) {
            HashSet<class_777> culled = new HashSet<class_777>(quads.size());
            culled.addAll(quads);
            quads = new ArrayList<class_777>(culled);
        }
        boolean added = false;
        for (class_777 quad : quads) {
            class_2960 resourceLocation;
            String iconName;
            class_1058 sprite = quad.method_35788();
            if (sprite == null || sprites.containsKey(iconName = sprite.method_45851().method_45816().method_12832()) || (resourceLocation = new class_2960(iconName)).equals((Object)new class_2960("missingno"))) continue;
            sprites.put(iconName, new ColoredSprite(quad));
            added = true;
        }
        return added;
    }
}

