/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.oddion;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7988;
import net.minecraft.class_7995;
import net.potionstudios.biomeswevegone.config.configs.BWGMobSpawnConfig;
import net.potionstudios.biomeswevegone.sounds.BWGSounds;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Oddion
extends class_1314
implements GeoEntity,
class_7988<Variant> {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("walking");
    private static final RawAnimation POP_UP = RawAnimation.begin().thenPlay("pop_up");
    private static final RawAnimation DANCE = RawAnimation.begin().thenPlay("dance");
    private static final RawAnimation GROUND = RawAnimation.begin().thenPlay("ground");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation PET = RawAnimation.begin().thenLoop("pet");
    private static final class_2940<Integer> RISING_TIMER = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> GROUNDING_TIMER = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PET_TIMER = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PARTYING = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> GROUNDED = class_2945.method_12791(Oddion.class, (class_2941)class_2943.field_13323);
    public int onionTime = 6000;
    public class_1352 movementGoal = new class_1394((class_1314)this, 1.0);
    @Nullable
    private class_2338 jukebox;

    public Oddion(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    public Oddion(class_1937 level) {
        this(BWGEntities.ODDION.get(), level);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PARTYING, (Object)false);
        this.field_6011.method_12784(GROUNDED, (Object)true);
        this.field_6011.method_12784(RISING_TIMER, (Object)0);
        this.field_6011.method_12784(GROUNDING_TIMER, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT, (Object)0);
        this.field_6011.method_12784(PET_TIMER, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 2.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.2, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8324}), false));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant().getId());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(Variant.byId(compound.method_10550("Variant")));
    }

    public static boolean checkOddionSpawnRules(class_1299<? extends Oddion> entity, class_1936 world, class_3730 spawnType, class_2338 pos, class_5819 rand) {
        return BWGMobSpawnConfig.INSTANCE.oddion && world.method_8320(pos.method_10074()).method_26164(class_3481.field_29822);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant(Variant.getSpawnVariant(level.method_8409()));
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.4);
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return BWGSounds.ODDION_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return BWGSounds.ODDION_DEATH.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return BWGSounds.ODDION_AMBIENT.get();
    }

    public void method_5773() {
        super.method_5773();
        this.method_18382();
    }

    public void method_6007() {
        if (!this.method_37908().method_8608()) {
            if (--this.onionTime <= 0) {
                this.method_5783(class_3417.field_15219, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.method_5706((class_1935)BWGItems.ODDION_BULB.get());
                this.method_32876(class_5712.field_28738);
                this.onionTime = 6000;
            }
            if (!this.isGrounded()) {
                if (this.jukebox == null || !this.jukebox.method_19769((class_2374)this.method_19538(), 3.46) || !this.method_37908().method_8320(this.jukebox).method_27852(class_2246.field_10223)) {
                    this.setPartying(false);
                    this.jukebox = null;
                }
                this.checkGoals();
                if (this.getRisingTime() > 0) {
                    this.setRisingTimer(this.getRisingTime() - 1);
                }
                if (this.method_37908().method_18467(class_1657.class, new class_238(this.method_24515()).method_1014(8.0)).isEmpty()) {
                    this.setGroundingTimer(this.getGroundingTime() + 1);
                }
            } else if (!this.method_37908().method_18467(class_1657.class, new class_238(this.method_24515()).method_1014(3.0)).isEmpty()) {
                this.setGrounded(false);
                this.setRisingTimer(20);
            }
            if (this.getGroundingTime() > 600) {
                this.setGrounded(true);
                this.field_6201.method_6280(this.movementGoal);
                this.setGroundingTimer(0);
            }
            if (this.isBeingPet()) {
                this.field_6201.method_6280(this.movementGoal);
                this.setPetTime(this.getPetTime() - 1);
            }
        }
        super.method_6007();
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (!this.isGrounded()) {
            this.petOddion();
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private void petOddion() {
        if (!this.method_37908().field_9236) {
            this.setPetTime(20);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), BWGSounds.ODDION_HAPPY.get(), class_3419.field_15248, 1.0f, 1.0f);
        }
        float expansion = 0.5f;
        for (int heartCount = 0; heartCount < this.method_37908().field_9229.method_43051(5, 10); ++heartCount) {
            double xSize = this.method_5829().method_17939();
            double ySize = this.method_5829().method_17940();
            double zSize = this.method_5829().method_17941();
            float randX = class_3532.method_32750((class_5819)this.method_37908().field_9229, (float)((float)(-xSize) - expansion), (float)((float)xSize + expansion)) / 2.0f;
            float randY = class_3532.method_32750((class_5819)this.method_37908().field_9229, (float)0.0f, (float)((float)ySize + expansion));
            float randZ = class_3532.method_32750((class_5819)this.method_37908().field_9229, (float)((float)(-zSize) - expansion), (float)((float)zSize + expansion)) / 2.0f;
            this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23317() + (double)randX, this.method_23318() + (double)randY, this.method_23321() + (double)randZ, 0.05, 0.1, 0.05);
        }
    }

    public void checkGoals() {
        if (this.field_6201.method_35115().stream().noneMatch(goal -> goal.method_19058().getClass() == class_1394.class)) {
            this.field_6201.method_6277(1, this.movementGoal);
        }
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.isGrounded()) {
            return event.setAndContinue(GROUND);
        }
        if (this.isRising()) {
            return event.setAndContinue(POP_UP);
        }
        if (this.isBeingPet()) {
            return event.setAndContinue(PET);
        }
        if (this.isPartying()) {
            return event.setAndContinue(DANCE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        return event.setAndContinue(IDLE);
    }

    private boolean isRising() {
        return this.getRisingTime() > 0;
    }

    public void method_6006(@NotNull class_2338 jukebox, boolean partying) {
        this.jukebox = jukebox;
        this.setPartying(partying);
        this.field_6201.method_6280(this.movementGoal);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public boolean isPartying() {
        return (Boolean)this.field_6011.method_12789(PARTYING);
    }

    public void setPartying(boolean flag) {
        this.field_6011.method_12778(PARTYING, (Object)flag);
    }

    public boolean isGrounded() {
        return (Boolean)this.field_6011.method_12789(GROUNDED);
    }

    public void setGrounded(boolean flag) {
        this.field_6011.method_12778(GROUNDED, (Object)flag);
    }

    public int getRisingTime() {
        return (Integer)this.field_6011.method_12789(RISING_TIMER);
    }

    public void setRisingTimer(int flag) {
        this.field_6011.method_12778(RISING_TIMER, (Object)flag);
    }

    public int getGroundingTime() {
        return (Integer)this.field_6011.method_12789(GROUNDING_TIMER);
    }

    public void setGroundingTimer(int flag) {
        this.field_6011.method_12778(GROUNDING_TIMER, (Object)flag);
    }

    public int getPetTime() {
        return (Integer)this.field_6011.method_12789(PET_TIMER);
    }

    public void setPetTime(int time) {
        this.field_6011.method_12778(PET_TIMER, (Object)time);
    }

    public boolean isBeingPet() {
        return this.getPetTime() > 0;
    }

    public void setVariant(@NotNull Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        if (this.isGrounded()) {
            return this.method_5864().method_18386().method_19539(1.0f, 0.25f);
        }
        return super.method_18377(pose);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT));
    }

    public static enum Variant implements class_3542
    {
        STANDARD(0, "standard"),
        PINK(1, "pink"),
        ALBINO(2, "albino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(@NotNull class_5819 random) {
            int i = random.method_43048(100);
            return i < 47 ? STANDARD : (i < 94 ? PINK : ALBINO);
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }
}

