/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.worldgen;

import com.simibubi.create.infrastructure.worldgen.LayerPattern;
import com.simibubi.create.infrastructure.worldgen.LayeredOreConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5867;

public class LayeredOreFeature
extends class_3031<LayeredOreConfiguration> {
    private static final float MAX_LAYER_DISPLACEMENT = 1.75f;
    private static final float LAYER_NOISE_FREQUENCY = 0.125f;
    private static final float MAX_RADIAL_THRESHOLD_REDUCTION = 0.25f;
    private static final float RADIAL_NOISE_FREQUENCY = 0.125f;

    public LayeredOreFeature() {
        super(LayeredOreConfiguration.CODEC);
    }

    public boolean method_13151(class_5821<LayeredOreConfiguration> pContext) {
        float layerSizeTotal;
        float layerSize;
        class_5819 random = pContext.method_33654();
        class_2338 origin = pContext.method_33655();
        class_5281 worldGenLevel = pContext.method_33652();
        LayeredOreConfiguration config = (LayeredOreConfiguration)pContext.method_33656();
        List<LayerPattern> patternPool = config.layerPatterns;
        if (patternPool.isEmpty()) {
            return false;
        }
        LayerPattern layerPattern = patternPool.get(random.method_43048(patternPool.size()));
        int placedAmount = 0;
        int size = config.size + 1;
        float radius = (float)config.size * 0.5f;
        int radiusBound = class_3532.method_15386((float)radius) - 1;
        int x0 = origin.method_10263();
        int y0 = origin.method_10264();
        int z0 = origin.method_10260();
        if (origin.method_10264() >= worldGenLevel.method_8624(class_2902.class_2903.field_13195, origin.method_10263(), origin.method_10260())) {
            return false;
        }
        ArrayList<TemporaryLayerEntry> tempLayers = new ArrayList<TemporaryLayerEntry>();
        LayerPattern.Layer current = null;
        for (layerSizeTotal = 0.0f; layerSizeTotal < (float)size; layerSizeTotal += layerSize) {
            LayerPattern.Layer next = layerPattern.rollNext(current, random);
            layerSize = class_3532.method_32750((class_5819)random, (float)next.minSize, (float)next.maxSize);
            tempLayers.add(new TemporaryLayerEntry(next, layerSize));
            current = next;
        }
        ArrayList<ResolvedLayerEntry> resolvedLayers = new ArrayList<ResolvedLayerEntry>(tempLayers.size());
        float cumulativeLayerSize = -(layerSizeTotal - (float)size) * random.method_43057();
        for (TemporaryLayerEntry tempLayerEntry : tempLayers) {
            float rampStartValue = resolvedLayers.size() == 0 ? Float.NEGATIVE_INFINITY : cumulativeLayerSize * (2.0f / (float)size) - 1.0f;
            if ((cumulativeLayerSize += tempLayerEntry.size()) < 0.0f) continue;
            float radialThresholdMultiplier = class_3532.method_32750((class_5819)random, (float)0.5f, (float)1.0f);
            resolvedLayers.add(new ResolvedLayerEntry(tempLayerEntry.layer, radialThresholdMultiplier, rampStartValue));
        }
        float gy = class_3532.method_32750((class_5819)random, (float)-1.0f, (float)1.0f);
        gy = (float)Math.cbrt(gy);
        float xzRescale = class_3532.method_15355((float)(1.0f - gy * gy));
        float theta = random.method_43057() * ((float)Math.PI * 2);
        float gx = class_3532.method_15362((float)theta) * xzRescale;
        float gz = class_3532.method_15374((float)theta) * xzRescale;
        class_3541 layerDisplacementNoise = new class_3541(random);
        class_3541 radiusNoise = new class_3541(random);
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        try (class_5867 bulkSectionAccess = new class_5867((class_1936)worldGenLevel);){
            for (int dzBlock = -radiusBound; dzBlock <= radiusBound; ++dzBlock) {
                float dz = (float)dzBlock * (1.0f / radius);
                if (dz * dz > 1.0f) continue;
                for (int dxBlock = -radiusBound; dxBlock <= radiusBound; ++dxBlock) {
                    float dx = (float)dxBlock * (1.0f / radius);
                    if (dz * dz + dx * dx > 1.0f) continue;
                    block9: for (int dyBlock = -radiusBound; dyBlock <= radiusBound; ++dyBlock) {
                        class_2826 levelChunkSection;
                        float thresholdNoiseValue;
                        float dy = (float)dyBlock * (1.0f / radius);
                        float distanceSquared = dz * dz + dx * dx + dy * dy;
                        if (distanceSquared > 1.0f || worldGenLevel.method_31601(y0 + dyBlock)) continue;
                        int currentX = x0 + dxBlock;
                        int currentY = y0 + dyBlock;
                        int currentZ = z0 + dzBlock;
                        float rampValue = gx * dx + gy * dy + gz * dz;
                        int layerIndex = Collections.binarySearch(resolvedLayers, new ResolvedLayerEntry(null, 0.0f, rampValue = (float)((double)rampValue + layerDisplacementNoise.method_22416((double)((float)currentX * 0.125f), (double)((float)currentY * 0.125f), (double)((float)currentZ * 0.125f)) * (double)(1.75f / (float)size))));
                        if (layerIndex < 0) {
                            layerIndex = -2 - layerIndex;
                        }
                        ResolvedLayerEntry layerEntry = (ResolvedLayerEntry)resolvedLayers.get(layerIndex);
                        if (distanceSquared > layerEntry.radialThresholdMultiplier || distanceSquared > layerEntry.radialThresholdMultiplier * (thresholdNoiseValue = class_3532.method_37959((float)((float)radiusNoise.method_22416((double)((float)currentX * 0.125f), (double)((float)currentY * 0.125f), (double)((float)currentZ * 0.125f))), (float)-1.0f, (float)1.0f, (float)0.75f, (float)1.0f))) continue;
                        LayerPattern.Layer layer = layerEntry.layer;
                        List<class_3124.class_5876> targetBlockStates = layer.rollBlock(random);
                        mutablePos.method_10103(currentX, currentY, currentZ);
                        if (!worldGenLevel.method_37368((class_2338)mutablePos) || (levelChunkSection = bulkSectionAccess.method_33944((class_2338)mutablePos)) == null) continue;
                        int localX = class_4076.method_18684((int)currentX);
                        int localY = class_4076.method_18684((int)currentY);
                        int localZ = class_4076.method_18684((int)currentZ);
                        class_2680 blockState = levelChunkSection.method_12254(localX, localY, localZ);
                        for (class_3124.class_5876 targetBlockState : targetBlockStates) {
                            if (!this.canPlaceOre(blockState, arg_0 -> ((class_5867)bulkSectionAccess).method_33946(arg_0), random, config, targetBlockState, mutablePos) || targetBlockState.field_29069.method_26215()) continue;
                            levelChunkSection.method_12256(localX, localY, localZ, targetBlockState.field_29069, false);
                            ++placedAmount;
                            continue block9;
                        }
                    }
                }
            }
        }
        return placedAmount > 0;
    }

    public boolean canPlaceOre(class_2680 pState, Function<class_2338, class_2680> pAdjacentStateAccessor, class_5819 pRandom, LayeredOreConfiguration pConfig, class_3124.class_5876 pTargetState, class_2338.class_2339 pMatablePos) {
        if (!pTargetState.field_29068.method_16768(pState, pRandom)) {
            return false;
        }
        if (this.shouldSkipAirCheck(pRandom, pConfig.discardChanceOnAirExposure)) {
            return true;
        }
        return !LayeredOreFeature.method_33981(pAdjacentStateAccessor, (class_2338)pMatablePos);
    }

    protected boolean shouldSkipAirCheck(class_5819 pRandom, float pChance) {
        return pChance <= 0.0f ? true : (pChance >= 1.0f ? false : pRandom.method_43057() >= pChance);
    }

    private record TemporaryLayerEntry(LayerPattern.Layer layer, float size) {
    }

    private record ResolvedLayerEntry(LayerPattern.Layer layer, float radialThresholdMultiplier, float rampStartValue) implements Comparable<ResolvedLayerEntry>
    {
        @Override
        public int compareTo(ResolvedLayerEntry b) {
            return Float.compare(this.rampStartValue, b.rampStartValue);
        }
    }
}

