/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_773;
import net.minecraft.class_7923;

public class BlockModelModifierReloadListener
implements class_3302 {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<class_1091, Properties> models = new HashMap<class_1091, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(class_1088 bakery) {
        HashSet<class_2960> models = new HashSet<class_2960>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        for (class_2960 model : models) {
            class_1100 unbakedModel = bakery.method_4726(model);
            bakery.field_5376.put(model, unbakedModel);
            bakery.field_5394.put(model, unbakedModel);
            unbakedModel.method_45785(arg_0 -> ((class_1088)bakery).method_4726(arg_0));
        }
    }

    public void applyOverlays(class_1088 bakery) {
        Map bakedModels = bakery.method_4734();
        for (Map.Entry<class_1091, Properties> entry : this.models.entrySet()) {
            class_1091 target = entry.getKey();
            class_1087 targetModel = (class_1087)bakedModels.get(target);
            Properties properties = entry.getValue();
            List<class_2960> overlays = properties.appendModels;
            List<class_1087> overlayModels = overlays.stream().map(bakedModels::get).toList();
            Object model = new BlockModelModifierBakedModel(targetModel, overlayModels);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((class_1087)model);
            }
            bakedModels.put(target, model);
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 barrier, class_3300 resourceManager, class_3695 profiler, class_3695 profiler2, Executor executor, Executor executor2) {
        return CompletableFuture.runAsync(() -> this.reload(resourceManager)).thenCompose(arg_0 -> ((class_3302.class_4045)barrier).method_18352(arg_0));
    }

    private void reload(class_3300 resourceManager) {
        this.models.clear();
        HashMap resources = new HashMap();
        class_4309.method_51148((class_3300)resourceManager, (String)LOCATION, (Gson)GSON, resources);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                class_2960 identifier = new class_2960(element.getAsString());
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
                if (block == null || block == class_2246.field_10124) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
                }
                block.method_9595().method_11662().stream().map(class_773::method_3340).forEach(targets::add);
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).map(class_773::method_3340).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<class_2960> models = new LinkedHashSet<class_2960>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(new class_2960(element.getAsString()));
            }
        }
        boolean paneCullingFix = false;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && !paneCullingFix) {
            return;
        }
        for (class_1091 target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<class_2680> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        class_2960 identifier = new class_2960(json.get("block").getAsString());
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
        if (block == null || block == class_2246.field_10124) {
            throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
        }
        HashMap<class_2769, ImmutableSet> properties = new HashMap<class_2769, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").size() == 0) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            class_2769 property = block.method_9595().method_11663((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + String.valueOf(identifier) + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.method_11900(((JsonElement)entry.getValue()).getAsString());
                if (value.isEmpty()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                    throw new JsonParseException("Valid values for property '" + property.method_11899() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.method_11900(element.getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of((class_2680)block.method_9595().method_11664());
        for (class_2769 property : block.method_9595().method_11659()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.method_30043().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.comp_71())));
        }
        return states;
    }

    private static <T extends Comparable<T>> class_2680 stateWithValue(class_2680 state, class_2769<?> property, Object value) {
        return (class_2680)state.method_11657(property, (Comparable)value);
    }

    public String method_22322() {
        return "Fusion Block Model Overlay Reload Listener";
    }

    private static class Properties {
        final List<class_2960> appendModels = new ArrayList<class_2960>();
        boolean paneCullingFix;

        private Properties() {
        }
    }
}

