/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.fabric.contents;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.contents.BargainTypeRegistry;

public final class FabricBargainTypeRegistry
implements BargainTypeRegistry,
SimpleSynchronousResourceReloadListener {
    private static final class_2960 ID = ParagliderAPI.id("bargain_types");
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String BASE_PATH = "paraglider/bargain_types";
    private static final Pattern PATH_REGEX = Pattern.compile("^paraglider/bargain_types/(.+)\\.json$");
    private static final FabricBargainTypeRegistry instance = new FabricBargainTypeRegistry();
    private final Map<class_2960, BargainType> bargainTypes = new Object2ObjectOpenHashMap();

    private FabricBargainTypeRegistry() {
    }

    @NotNull
    public static FabricBargainTypeRegistry get() {
        return instance;
    }

    @NotNull
    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(@NotNull class_3300 resources) {
        this.bargainTypes.clear();
        for (Map.Entry e : resources.method_14488(ID.method_12836() + "/" + ID.method_12832(), path -> path.method_12832().endsWith(".json")).entrySet()) {
            Matcher m = PATH_REGEX.matcher(((class_2960)e.getKey()).method_12832());
            if (!m.matches()) {
                ParagliderMod.LOGGER.error("Cannot read bargain type at {}: Invalid path", e.getKey());
                continue;
            }
            class_2960 id = new class_2960(((class_2960)e.getKey()).method_12836(), m.group(1));
            try {
                InputStream stream = ((class_3298)e.getValue()).method_14482();
                try {
                    JsonElement json = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonElement.class);
                    BargainType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).get().map(bargainType -> {
                        ParagliderMod.LOGGER.debug("Read bargain type {}: {}", (Object)id, bargainType);
                        this.bargainTypes.put(id, (BargainType)bargainType);
                        return null;
                    }, err -> {
                        ParagliderMod.LOGGER.error("Cannot read bargain type {}: {}", (Object)id, err);
                        return null;
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException ex) {
                ParagliderMod.LOGGER.error("Cannot read bargain type {}", (Object)id, (Object)ex);
            }
        }
    }

    @Override
    @Nullable
    public BargainType getFromID(@NotNull class_5455 registryAccess, @NotNull class_2960 id) {
        return this.bargainTypes.get(id);
    }
}

