/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.fabric;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.fabric.NetworkIDs;
import tictim.paraglider.network.ClientPacketHandler;
import tictim.paraglider.network.ParagliderNetworkBase;
import tictim.paraglider.network.ServerPacketHandler;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.BargainMsg;
import tictim.paraglider.network.message.Msg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;

public final class FabricParagliderNetwork
extends ParagliderNetworkBase {
    private static final FabricParagliderNetwork instance = new FabricParagliderNetwork();

    private FabricParagliderNetwork() {
    }

    public static FabricParagliderNetwork get() {
        return instance;
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.BARGAIN_END, (server, player, handler, buf, responseSender) -> {
            BargainEndMsg msg = BargainEndMsg.read(buf);
            server.execute(() -> ServerPacketHandler.handleBargainEnd(player, msg));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.BARGAIN, (server, player, handler, buf, responseSender) -> {
            BargainMsg msg = BargainMsg.read(buf);
            server.execute(() -> ServerPacketHandler.handleBargain(player, msg));
        });
    }

    public static void clientInit() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.BARGAIN_DIALOG, (client, handler, buf, responseSender) -> {
            BargainDialogMsg msg = BargainDialogMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleBargainDialog(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.BARGAIN_END, (client, handler, buf, responseSender) -> {
            BargainEndMsg msg = BargainEndMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleBargainEnd(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.BARGAIN_INIT, (client, handler, buf, responseSender) -> {
            BargainInitMsg msg = BargainInitMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleBargainInit(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_CATALOG, (client, handler, buf, responseSender) -> {
            SyncCatalogMsg msg = SyncCatalogMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncCatalog(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_LOOK_AT, (client, handler, buf, responseSender) -> {
            SyncLookAtMsg msg = SyncLookAtMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncLookAt(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_MOVEMENT, (client, handler, buf, responseSender) -> {
            SyncMovementMsg msg = SyncMovementMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncMovement(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_PLAYER_STATE_MAP, (client, handler, buf, responseSender) -> {
            SyncPlayerStateMapMsg msg = SyncPlayerStateMapMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncPlayerStateMap(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_REMOTE_MOVEMENT, (client, handler, buf, responseSender) -> {
            SyncRemoteMovementMsg msg = SyncRemoteMovementMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncRemoteMovement(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_VESSEL, (client, handler, buf, responseSender) -> {
            SyncVesselMsg msg = SyncVesselMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncVessel(msg));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIDs.SYNC_WIND, (client, handler, buf, responseSender) -> {
            SyncWindMsg msg = SyncWindMsg.read(buf);
            client.execute(() -> ClientPacketHandler.handleSyncWind(msg));
        });
    }

    @Override
    protected void sendToAll(@NotNull MinecraftServer server, @NotNull Msg msg) {
        Collection players = PlayerLookup.all((MinecraftServer)server);
        if (players.isEmpty()) {
            return;
        }
        Pair<class_2960, class_2540> pair = FabricParagliderNetwork.prepare(msg);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)((class_2960)pair.getFirst()), (class_2540)((class_2540)pair.getSecond()));
        }
    }

    @Override
    protected void sendToPlayer(@NotNull class_3222 player, @NotNull Msg msg) {
        Pair<class_2960, class_2540> pair = FabricParagliderNetwork.prepare(msg);
        ServerPlayNetworking.send((class_3222)player, (class_2960)((class_2960)pair.getFirst()), (class_2540)((class_2540)pair.getSecond()));
    }

    @Override
    protected void sendToTracking(@NotNull MinecraftServer server, @NotNull class_1297 entity, @NotNull Msg msg) {
        Collection players = PlayerLookup.tracking((class_1297)entity);
        if (players.isEmpty()) {
            return;
        }
        Pair<class_2960, class_2540> pair = FabricParagliderNetwork.prepare(msg);
        for (class_3222 player : players) {
            if (player == entity) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)((class_2960)pair.getFirst()), (class_2540)((class_2540)pair.getSecond()));
        }
    }

    @Override
    protected void sendToTracking(@NotNull MinecraftServer server, @NotNull class_2818 chunk, @NotNull Msg msg) {
        class_1937 class_19372 = chunk.method_12200();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        Collection players = PlayerLookup.tracking((class_3218)serverLevel, (class_1923)chunk.method_12004());
        if (players.isEmpty()) {
            return;
        }
        Pair<class_2960, class_2540> pair = FabricParagliderNetwork.prepare(msg);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)((class_2960)pair.getFirst()), (class_2540)((class_2540)pair.getSecond()));
        }
    }

    @Override
    protected void sendToServer(@NotNull Msg msg) {
        Pair<class_2960, class_2540> pair = FabricParagliderNetwork.prepare(msg);
        ClientPlayNetworking.send((class_2960)((class_2960)pair.getFirst()), (class_2540)((class_2540)pair.getSecond()));
    }

    @NotNull
    private static @NotNull Pair<@NotNull class_2960, @NotNull class_2540> prepare(@NotNull Msg msg) {
        class_2960 id;
        if (msg instanceof BargainDialogMsg) {
            id = NetworkIDs.BARGAIN_DIALOG;
        } else if (msg instanceof BargainEndMsg) {
            id = NetworkIDs.BARGAIN_END;
        } else if (msg instanceof BargainInitMsg) {
            id = NetworkIDs.BARGAIN_INIT;
        } else if (msg instanceof BargainMsg) {
            id = NetworkIDs.BARGAIN;
        } else if (msg instanceof SyncCatalogMsg) {
            id = NetworkIDs.SYNC_CATALOG;
        } else if (msg instanceof SyncLookAtMsg) {
            id = NetworkIDs.SYNC_LOOK_AT;
        } else if (msg instanceof SyncMovementMsg) {
            id = NetworkIDs.SYNC_MOVEMENT;
        } else if (msg instanceof SyncPlayerStateMapMsg) {
            id = NetworkIDs.SYNC_PLAYER_STATE_MAP;
        } else if (msg instanceof SyncRemoteMovementMsg) {
            id = NetworkIDs.SYNC_REMOTE_MOVEMENT;
        } else if (msg instanceof SyncVesselMsg) {
            id = NetworkIDs.SYNC_VESSEL;
        } else if (msg instanceof SyncWindMsg) {
            id = NetworkIDs.SYNC_WIND;
        } else {
            throw new IllegalStateException("@Tictim <<< laugh at this user!!!");
        }
        class_2540 buf = PacketByteBufs.create();
        msg.write(buf);
        return Pair.of((Object)id, (Object)buf);
    }
}

