/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.contents.Contents;

public class CosmeticRecipe
implements class_3955 {
    protected final class_2960 id;
    protected final String group;
    protected final class_1856 input;
    protected final class_1856 reagent;
    protected final class_1792 recipeOut;

    public CosmeticRecipe(@NotNull class_2960 id, @NotNull String group, @NotNull class_1856 input, @NotNull class_1856 reagent, @NotNull class_1792 recipeOut) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.reagent = reagent;
        this.recipeOut = recipeOut;
    }

    public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 level) {
        boolean paragliderSeen = false;
        boolean reagentSeen = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (this.reagent.method_8093(stack)) {
                if (reagentSeen) {
                    return false;
                }
                reagentSeen = true;
                continue;
            }
            if (this.input.method_8093(stack) && stack.method_7909() != this.recipeOut) {
                if (paragliderSeen) {
                    return false;
                }
                paragliderSeen = true;
                continue;
            }
            return false;
        }
        return paragliderSeen && reagentSeen;
    }

    @NotNull
    public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registryAccess) {
        class_1799 paraglider = new class_1799((class_1935)this.recipeOut);
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || this.reagent.method_8093(stack) || !this.input.method_8093(stack)) continue;
            if (stack.method_7985()) {
                paraglider.method_7980(stack.method_7969());
            }
            return paraglider;
        }
        return paraglider;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_5455 registryAccess) {
        return new class_1799((class_1935)this.recipeOut);
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_8566 inv) {
        class_2371 list = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (this.reagent.method_8093(stack)) {
                class_1799 copy = stack.method_7972();
                copy.method_7939(1);
                list.set(i, (Object)copy);
                continue;
            }
            int i0 = i;
            ParagliderUtils.forRemainingItem(stack, rem -> list.set(i0, rem));
        }
        return list;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        class_2371 list = class_2371.method_10211();
        list.add((Object)class_1856.method_8101((class_1799[])((class_1799[])Arrays.stream(this.input.method_8105()).filter(it -> it.method_7909() != this.recipeOut).toArray(class_1799[]::new))));
        list.add((Object)this.reagent);
        return list;
    }

    @NotNull
    public String method_8112() {
        return this.group;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Contents.get().cosmeticRecipeSerializer();
    }

    @NotNull
    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public static class Serializer
    implements class_1865<CosmeticRecipe> {
        @NotNull
        public CosmeticRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2960 itemName = new class_2960(class_3518.method_15265((JsonObject)json, (String)"result"));
            class_1792 item = ParagliderUtils.getItem(itemName);
            if (item == class_1802.field_8162) {
                throw new JsonSyntaxException("Unknown item '" + group + "'");
            }
            class_1856 input = class_1856.method_52177((JsonElement)json.get("input"));
            class_1856 reagent = class_1856.method_52177((JsonElement)json.get("reagent"));
            return new CosmeticRecipe(recipeId, group, input, reagent, item);
        }

        @NotNull
        public CosmeticRecipe fromNetwork(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
            String group = buffer.method_19772();
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            class_1856 reagent = class_1856.method_8086((class_2540)buffer);
            class_1792 out = class_1792.method_7875((int)buffer.method_10816());
            return new CosmeticRecipe(recipeId, group, input, reagent, out);
        }

        public void toNetwork(@NotNull class_2540 buffer, @NotNull CosmeticRecipe recipe) {
            buffer.method_10814(recipe.group);
            recipe.input.method_8088(buffer);
            recipe.reagent.method_8088(buffer);
            buffer.method_10804(class_1792.method_7880((class_1792)recipe.recipeOut));
        }
    }
}

