/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;

public final class BlockMatcher {
    private static final BlockMatcher empty = new BlockMatcher(new String[0], null, null);
    private static final Pattern REGEX = Pattern.compile("^#((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)|((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)(?:\\s*#\\s*([A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+(?:\\s*,\\s*[A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+)*))?$");
    private static final int GROUP_TAG = 1;
    private static final int GROUP_BLOCK_ID = 2;
    private static final int GROUP_PROPERTIES = 3;
    private final String[] inputs;
    private final Map<class_2248, Predicate<class_2680>> blockMatches;
    private final Set<class_6862<class_2248>> tagMatches;

    @NotNull
    public static BlockMatcher empty() {
        return empty;
    }

    @NotNull
    public static Result parse(@NotNull Collection<? extends String> inputs) {
        return new Result(inputs.toArray(new String[0]));
    }

    @NotNull
    public static BlockMatcher read(@NotNull class_2540 buffer) {
        String[] inputs = new String[buffer.method_10816()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = buffer.method_19772();
        }
        return new Result(inputs).result();
    }

    private BlockMatcher(@NotNull @NotNull String @NotNull [] inputs, @Nullable Map<@NotNull class_2248, Predicate<class_2680>> blockMatches, @Nullable Set<@NotNull class_6862<class_2248>> tagMatches) {
        this.inputs = inputs;
        this.blockMatches = blockMatches;
        this.tagMatches = tagMatches;
    }

    public boolean test(@NotNull class_2680 state) {
        Predicate<class_2680> predicate;
        if (this.blockMatches != null && (predicate = this.blockMatches.get(state.method_26204())) != null && predicate.test(state)) {
            return true;
        }
        if (this.tagMatches != null) {
            for (class_6862<class_2248> tag : this.tagMatches) {
                if (!ParagliderUtils.hasTag(state.method_26204(), tag)) continue;
                return true;
            }
        }
        return false;
    }

    public void write(@NotNull class_2540 buffer) {
        buffer.method_10804(this.inputs.length);
        for (String input : this.inputs) {
            buffer.method_10814(input);
        }
    }

    public static final class Result {
        private final BlockMatcher result;
        @Nullable
        private List<Error> errors;

        private Result(@NotNull @NotNull String @NotNull [] inputs) {
            Object2ObjectOpenHashMap blockMatches = null;
            ObjectOpenHashSet tagMatches = null;
            Matcher m = REGEX.matcher("");
            for (String input : inputs) {
                if (!m.reset(input).matches()) {
                    this.addError(input, "Malformed input");
                    continue;
                }
                if (m.group(1) != null) {
                    if (tagMatches == null) {
                        tagMatches = new ObjectOpenHashSet();
                    }
                    tagMatches.add(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(m.group(1))));
                    continue;
                }
                class_2248 block = ParagliderUtils.getBlock(new class_2960(m.group(2)));
                if (block == class_2246.field_10124) {
                    this.addError(input, "No block named '" + m.group(2) + "' exists");
                    continue;
                }
                Predicate<class_2680> p = this.parseBlockMatch(input, m, block);
                if (p == null) continue;
                if (blockMatches == null) {
                    blockMatches = new Object2ObjectOpenHashMap();
                }
                blockMatches.compute(block, (k, v) -> v == null ? p : v.or(p));
            }
            this.result = new BlockMatcher(inputs, (Map<class_2248, Predicate<class_2680>>)blockMatches, (Set<class_6862<class_2248>>)tagMatches);
        }

        @Nullable
        private Predicate<class_2680> parseBlockMatch(String input, Matcher matcher, class_2248 block) {
            String blockState = matcher.group(3);
            if (blockState == null) {
                return class_2715.field_12419;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String s : blockState.split(",")) {
                int i = s.indexOf(61);
                String key = s.substring(0, i);
                if (properties.containsKey(key)) {
                    this.addError(input, "Same property '" + key + "' checked twice");
                    return null;
                }
                properties.put(key, s.substring(i + 1));
            }
            IdentityHashMap parsedProperties = new IdentityHashMap();
            for (Map.Entry e : properties.entrySet()) {
                String key = (String)e.getKey();
                class_2769 property = block.method_9595().method_11663(key);
                if (property == null) {
                    this.addError(input, "Property with name '" + key + "' does not exist on block properties");
                    return null;
                }
                if (parsedProperties.containsKey(property)) {
                    this.addError(input, "Same property '" + key + "' checked twice");
                    return null;
                }
                Optional o2 = property.method_11900((String)e.getValue());
                if (o2.isEmpty()) {
                    this.addError(input, "Property with name '" + key + "' does not contain value '" + (String)e.getValue() + "'");
                    return null;
                }
                parsedProperties.put(property, o2.get());
            }
            class_2715 m = class_2715.method_11758((class_2248)block);
            for (Map.Entry e : parsedProperties.entrySet()) {
                Object v = e.getValue();
                m.method_11762((class_2769)e.getKey(), o -> o != null && o.equals(v));
            }
            return m;
        }

        private void addError(String input, String cause) {
            if (this.errors == null) {
                this.errors = new ArrayList<Error>();
            }
            this.errors.add(new Error(input, cause));
        }

        @NotNull
        public BlockMatcher result() {
            return this.result;
        }

        @NotNull
        public @Unmodifiable List<Error> errors() {
            return this.errors == null ? List.of() : Collections.unmodifiableList(this.errors);
        }

        public void printErrors() {
            if (this.errors == null || this.errors.isEmpty()) {
                return;
            }
            ParagliderMod.LOGGER.warn("Found {} error(s) in wind source configuration:", (Object)this.errors.size());
            for (Error error : this.errors) {
                ParagliderMod.LOGGER.warn("  \"{}\": {}", (Object)error.input, (Object)error.cause);
            }
        }
    }

    public record Error(String input, String cause) {
    }
}

