/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_3784;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class LithostitchedTemplates
implements Iterable<class_3784> {
    protected final List<WeightedEntry> entries = Lists.newArrayList();

    public LithostitchedTemplates add(class_3784 element, int weight) {
        this.entries.add(new WeightedEntry(element, this.entries.size(), weight));
        return this;
    }

    public List<class_3784> shuffle(class_5819 random) {
        ArrayList shuffled = Lists.newArrayList(this.entries.stream().map(WeightedEntry::copy).toList());
        shuffled.forEach(entry -> entry.setRandom(random.method_43057()));
        shuffled.sort(Comparator.comparingDouble(WeightedEntry::getRandWeight));
        return shuffled.stream().map(WeightedEntry::getElement).toList();
    }

    public Stream<class_3784> stream() {
        return this.entries.stream().map(WeightedEntry::getElement);
    }

    @Override
    @NotNull
    public Iterator<class_3784> iterator() {
        return Iterators.transform(this.entries.iterator(), WeightedEntry::getElement);
    }

    public static class WeightedEntry {
        final class_3784 element;
        final int index;
        final int weight;
        private double randWeight;
        private final boolean prioritized;

        WeightedEntry(class_3784 element, int index, int weight) {
            DelegatingPoolElement delegating;
            this.element = element;
            this.index = index;
            this.weight = weight;
            this.prioritized = element instanceof DelegatingPoolElement && (delegating = (DelegatingPoolElement)element).prioritized();
        }

        private WeightedEntry copy() {
            return new WeightedEntry(this.element, this.index, this.weight);
        }

        private double getRandWeight() {
            return this.randWeight;
        }

        void setRandom(float value) {
            this.randWeight = -Math.pow(value, 1.0f / (float)this.weight) + (double)(this.prioritized ? -2 : 0);
        }

        public class_3784 getElement() {
            return this.element;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.weight + ":" + this.element;
        }
    }
}

