/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.TrueModifierPredicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_3542;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface Modifier {
    public static final Codec<Modifier> CODEC = class_5699.method_39240(() -> {
        class_2378 modifierRegistry = (class_2378)class_7923.field_41167.method_10223(LithostitchedRegistryKeys.MODIFIER_TYPE.method_29177());
        if (modifierRegistry == null) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return modifierRegistry.method_39673();
    }).dispatch(Modifier::codec, Function.identity());

    public static <P extends Modifier> Products.P1<RecordCodecBuilder.Mu<P>, ModifierPredicate> addModifierFields(RecordCodecBuilder.Instance<P> codec) {
        return codec.group((App)ModifierPredicate.CODEC.fieldOf("predicate").orElse((Object)TrueModifierPredicate.INSTANCE).forGetter(Modifier::getPredicate));
    }

    public ModifierPredicate getPredicate();

    public ModifierPhase getPhase();

    default public void applyModifier(class_5455 registryAccess) {
        this.applyModifier();
    }

    public void applyModifier();

    public Codec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        class_5455.class_6890 registries = server.method_30611();
        class_2378 modifiers = registries.method_30530(LithostitchedRegistryKeys.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            List<Modifier> phaseModifiers = modifiers.method_10220().filter(modifier -> modifier.getPhase() == phase).toList();
            Modifier.applyPhaseModifiers((class_5455)registries, phaseModifiers);
        }
    }

    private static void applyPhaseModifiers(class_5455 registries, List<Modifier> phaseModifiers) {
        ArrayList<PriorityBasedModifier> priorityBasedModifiers = new ArrayList<PriorityBasedModifier>();
        for (Modifier modifier : phaseModifiers) {
            if (modifier instanceof PriorityBasedModifier) {
                PriorityBasedModifier priorityModifier = (PriorityBasedModifier)modifier;
                priorityBasedModifiers.add(priorityModifier);
                continue;
            }
            modifier.applyModifier(registries);
        }
        for (Modifier modifier : Modifier.sortByPriority(priorityBasedModifiers)) {
            modifier.applyModifier(registries);
        }
    }

    public static List<PriorityBasedModifier> sortByPriority(List<PriorityBasedModifier> modifiers) {
        return modifiers.stream().sorted(Comparator.comparingInt(PriorityBasedModifier::getPriority)).toList();
    }

    public static enum ModifierPhase implements class_3542
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        REPLACE("replace"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

