/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.fabric;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.FabricConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.fabric.RegHelperImpl;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.misc.FakeLevelManager;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.network.fabric.ClientBoundOpenScreenMessage;
import net.mehvahdjukaar.moonlight.fabric.MLFabricSetupCallbacks;
import net.mehvahdjukaar.moonlight.fabric.ResourceConditionsBridge;
import net.minecraft.server.MinecraftServer;

public class MoonlightFabric
implements ModInitializer,
DedicatedServerModInitializer {
    private static boolean isInit = true;
    private static MinecraftServer currentServer;
    public static final Queue<Runnable> COMMON_SETUP_WORK;
    public static final Queue<Runnable> PRE_SETUP_WORK;
    public static final Queue<Runnable> AFTER_SETUP_WORK;

    public void onInitialize() {
        Moonlight.commonInit();
        ModMessages.CHANNEL.register(NetworkDir.PLAY_TO_CLIENT, ClientBoundOpenScreenMessage.class, ClientBoundOpenScreenMessage::new);
        ServerPlayConnectionEvents.JOIN.register((l, s, m) -> ModMessages.CHANNEL.sendToClientPlayer(l.field_14140, new ClientBoundSendLoginPacket()));
        ServerLifecycleEvents.SERVER_STARTING.register(s -> {
            currentServer = s;
            Moonlight.beforeServerStart();
        });
        CommonLifecycleEvents.TAGS_LOADED.register(Moonlight::afterDataReload);
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            currentServer = null;
            FakeLevelManager.invalidateAll();
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(SoftFluidInternal::onDataSyncToPlayer);
        ServerPlayerEvents.COPY_FROM.register(Moonlight::onPlayerCloned);
        ResourceConditionsBridge.init();
    }

    static void commonSetup() {
        RegHelperImpl.lateRegisterEntries();
        FabricConfigSpec.loadAllConfigs();
        MLFabricSetupCallbacks.COMMON_SETUP.forEach(Runnable::run);
        MLFabricSetupCallbacks.COMMON_SETUP.clear();
        isInit = false;
        PRE_SETUP_WORK.forEach(Runnable::run);
        COMMON_SETUP_WORK.forEach(Runnable::run);
        AFTER_SETUP_WORK.forEach(Runnable::run);
        PRE_SETUP_WORK.clear();
        COMMON_SETUP_WORK.clear();
        AFTER_SETUP_WORK.clear();
    }

    public void onInitializeServer() {
        MoonlightFabric.commonSetup();
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean isInitializing() {
        return isInit;
    }

    static {
        COMMON_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
        PRE_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
        AFTER_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
    }
}

