/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.runtime.EmiLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public interface EmiStackSerializer<T extends EmiStack>
extends EmiIngredientSerializer<T> {
    public static final Pattern STACK_REGEX = Pattern.compile("^([\\w_\\-./]+):([\\w_\\-.]+):([\\w_\\-./]+)(\\{.*\\})?$");

    public EmiStack create(class_2960 var1, class_2487 var2, long var3);

    @Override
    default public EmiIngredient deserialize(JsonElement element) {
        class_2960 id = null;
        String nbt = null;
        long amount = 1L;
        float chance = 1.0f;
        EmiStack remainder = EmiStack.EMPTY;
        if (class_3518.method_15286((JsonElement)element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = EmiPort.id(m.group(2), m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            EmiIngredient ing;
            JsonObject json = element.getAsJsonObject();
            id = EmiPort.id(class_3518.method_15265((JsonObject)json, (String)"id"));
            nbt = class_3518.method_15253((JsonObject)json, (String)"nbt", null);
            amount = class_3518.method_15280((JsonObject)json, (String)"amount", (long)1L);
            chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
            if (class_3518.method_15294((JsonObject)json, (String)"remainder") && (ing = EmiIngredientSerializer.getDeserialized(json.get("remainder"))) instanceof EmiStack) {
                EmiStack stack;
                remainder = stack = (EmiStack)ing;
            }
        }
        if (id != null) {
            try {
                class_2487 nbtComp = null;
                if (nbt != null) {
                    nbtComp = class_2522.method_10718(nbt);
                }
                EmiStack stack = this.create(id, nbtComp, amount);
                if (chance != 1.0f) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }
                return stack;
            }
            catch (Exception e) {
                EmiLog.error("Error parsing NBT in deserialized stack");
                e.printStackTrace();
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }

    @Override
    default public JsonElement serialize(T stack) {
        if (((EmiStack)stack).getAmount() == 1L && ((EmiStack)stack).getChance() == 1.0f && ((EmiStack)stack).getRemainder().isEmpty()) {
            String s = this.getType() + ":" + ((EmiStack)stack).getId();
            if (((EmiStack)stack).hasNbt()) {
                s = s + ((EmiStack)stack).getNbt().method_10714();
            }
            return new JsonPrimitive(s);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("id", ((EmiStack)stack).getId().toString());
        if (((EmiStack)stack).hasNbt()) {
            json.addProperty("nbt", ((EmiStack)stack).getNbt().method_10714());
        }
        if (((EmiStack)stack).getAmount() != 1L) {
            json.addProperty("amount", (Number)((EmiStack)stack).getAmount());
        }
        if (((EmiStack)stack).getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(((EmiStack)stack).getChance()));
        }
        if (!((EmiStack)stack).getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = ((EmiStack)stack).getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized(remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }
}

