/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.libs.org.spongepowered.configurate.serialize;

import com.epherical.epherolib.libs.io.leangen.geantyref.TypeToken;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.AbstractListChildSerializer;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.epherical.epherolib.libs.org.spongepowered.configurate.util.CheckedConsumer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    static final TypeToken<List<?>> TYPE = new TypeToken<List<?>>(){};

    ListSerializer() {
    }

    @Override
    protected Type elementType(Type containerType) throws SerializationException {
        if (!(containerType instanceof ParameterizedType)) {
            throw new SerializationException(containerType, "Raw types are not supported for collections");
        }
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }

    @Override
    protected List<?> createNew(int length, Type elementType) {
        return new ArrayList(length);
    }

    @Override
    protected void forEachElement(List<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    protected void deserializeSingle(int index, List<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

