/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.WeatheringChainBlock;
import com.supermartijn642.additionallanterns.WeatheringLanternBlock;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_4970;
import net.minecraft.class_5955;

public enum LanternMaterial {
    AMETHYST(true, true, "Amethyst", () -> class_1802.field_27063, null, 4, () -> class_1802.field_27064, () -> class_1802.field_27063, 8),
    ANDESITE(true, true, "Andesite", () -> class_1802.field_20407, null, 12, () -> class_1802.field_20407, () -> class_1802.field_20407, 16),
    BASALT(true, true, "Basalt", () -> class_1802.field_22000, null, 12, () -> class_1802.field_22000, () -> class_1802.field_22000, 16),
    BLACKSTONE(true, true, "Blackstone", () -> class_1802.field_23843, null, 12, () -> class_1802.field_23843, () -> class_1802.field_23843, 16),
    BONE(true, true, "Bone", () -> class_1802.field_8606, () -> class_1802.field_8606, 4, () -> class_1802.field_8242, () -> class_1802.field_8606, 8),
    BRICKS(true, true, "Brick", () -> class_1802.field_8621, null, 2, () -> class_1802.field_20390, () -> class_1802.field_8621, 8),
    COBBLESTONE(true, true, "Cobblestone", () -> class_1802.field_20412, null, 12, () -> class_1802.field_20412, () -> class_1802.field_20412, 16),
    COBBLED_DEEPSLATE(true, true, "Cobbled Deepslate", () -> class_1802.field_29025, null, 12, () -> class_1802.field_29025, () -> class_1802.field_29025, 16),
    COPPER(true, true, "Copper", () -> class_1802.field_27022, null, 4, () -> class_1802.field_27071, () -> class_1802.field_27022, 16),
    CRIMSON(true, true, "Crimson", () -> class_1802.field_22031, null, 8, () -> class_1802.field_22031, () -> class_1802.field_22031, 16),
    DARK_PRISMARINE(true, true, "Dark Prismarine", () -> class_1802.field_20406, null, 12, () -> class_1802.field_20406, () -> class_1802.field_8662, 8),
    DEEPSLATE_BRICKS(true, true, "Deepslate Bricks", () -> class_1802.field_28859, null, 12, () -> class_1802.field_28859, () -> class_1802.field_28859, 16),
    DIAMOND(true, true, "Diamond", () -> class_1802.field_8477, null, 8, () -> class_1802.field_8477, () -> class_1802.field_8477, 4),
    DIORITE(true, true, "Diorite", () -> class_1802.field_20401, null, 12, () -> class_1802.field_20401, () -> class_1802.field_20401, 16),
    EMERALD(true, true, "Emerald", () -> class_1802.field_8687, null, 8, () -> class_1802.field_8687, () -> class_1802.field_8687, 4),
    END_STONE(true, true, "End Stone", () -> class_1802.field_20399, null, 12, () -> class_1802.field_20399, () -> class_1802.field_20399, 16),
    EXPOSED_COPPER(true, true, "Exposed Copper", null, null, 0, null, null, 0),
    GOLD(true, true, "Gold", () -> class_1802.field_8397, (class_1935)class_1802.field_8397, 1, () -> class_1802.field_8695, () -> class_1802.field_8397, 1),
    GRANITE(true, true, "Granite", () -> class_1802.field_20394, null, 12, () -> class_1802.field_20394, () -> class_1802.field_20394, 16),
    IRON(true, false, "Iron", () -> class_1802.field_8620, null, 4, null, null, 0),
    MOSSY_COBBLESTONE(true, true, "Mossy Cobblestone", () -> class_1802.field_20392, null, 12, () -> class_1802.field_20392, () -> class_1802.field_20412, 16),
    NETHERITE(true, true, "Netherite", () -> class_1802.field_22020, null, 8, () -> class_1802.field_22020, () -> class_1802.field_22020, 4),
    NORMAL(true, false, "", null, null, 0, null, null, 0),
    NORMAL_NETHER_BRICKS(true, true, "Nether Brick", () -> class_1802.field_8729, null, 4, () -> class_1802.field_20398, () -> class_1802.field_8729, 16),
    NORMAL_SANDSTONE(true, true, "Sandstone", () -> class_1802.field_20384, null, 12, () -> class_1802.field_20384, () -> class_1802.field_20384, 16),
    OBSIDIAN(true, true, "Obsidian", () -> class_1802.field_8281, null, 12, () -> class_1802.field_8281, () -> class_1802.field_8281, 16),
    OXIDIZED_COPPER(true, true, "Oxidized Copper", null, null, 0, null, null, 0),
    PRISMARINE(true, true, "Prismarine", () -> class_1802.field_8662, null, 4, () -> class_1802.field_20405, () -> class_1802.field_8662, 8),
    PURPUR(true, true, "Purpur", () -> class_1802.field_8882, null, 1, () -> class_1802.field_20393, () -> class_1802.field_8882, 8),
    QUARTZ(true, true, "Quartz", () -> class_1802.field_8155, () -> class_1802.field_8155, 4, () -> class_1802.field_20402, () -> class_1802.field_8155, 8),
    RED_NETHER_BRICKS(true, true, "Red Nether Brick", () -> class_1802.field_20410, null, 12, () -> class_1802.field_20410, () -> class_1802.field_8729, 8),
    RED_SANDSTONE(true, true, "Red Sandstone", () -> class_1802.field_20408, null, 12, () -> class_1802.field_20408, () -> class_1802.field_20408, 16),
    SMOOTH_STONE(true, true, "Smooth Stone", () -> class_1802.field_20389, null, 12, () -> class_1802.field_20389, () -> class_1802.field_20389, 16),
    STONE(true, true, "Stone", () -> class_1802.field_20391, null, 12, () -> class_1802.field_20391, () -> class_1802.field_20391, 16),
    STONE_BRICKS(true, true, "Stone Bricks", () -> class_1802.field_20395, null, 12, () -> class_1802.field_20395, () -> class_1802.field_20395, 16),
    WARPED(true, true, "Warped", () -> class_1802.field_22032, null, 8, () -> class_1802.field_22032, () -> class_1802.field_22032, 16),
    WAXED_COPPER(true, true, "Waxed Copper", null, null, 0, null, null, 0),
    WAXED_EXPOSED_COPPER(true, true, "Waxed Exposed Copper", null, null, 0, null, null, 0),
    WAXED_OXIDIZED_COPPER(true, true, "Waxed Oxidized Copper", null, null, 0, null, null, 0),
    WAXED_WEATHERED_COPPER(true, true, "Waxed Weathered Copper", null, null, 0, null, null, 0),
    WEATHERED_COPPER(true, true, "Weathered Copper", null, null, 0, null, null, 0);

    private static final Map<LanternMaterial, class_5955.class_5811> WEATHERING_BLOCKS;
    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private class_1792 lanternItem;
    private final Map<LanternColor, class_1792> coloredLanternItems = new EnumMap<LanternColor, class_1792>(LanternColor.class);
    private class_1792 chainItem;
    public final String englishTranslation;
    public final class_1935 primaryLanternIngredient;
    public final class_1935 secondaryLanternIngredient;
    public final int lanternRecipeCount;
    public final class_1935 primaryChainIngredient;
    public final class_1935 secondaryChainIngredient;
    public final int chainRecipeCount;

    private LanternMaterial(boolean canBeColored, boolean hasChains, String englishTranslation, class_1935 primaryLanternIngredient, class_1935 secondaryLanternIngredient, int lanternRecipeCount, class_1935 primaryChainIngredient, class_1935 secondaryChainIngredient, int chainRecipeCount) {
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.lanternRecipeCount = lanternRecipeCount;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
    }

    public class_2248 getLanternBlock() {
        return this.lanternBlock;
    }

    public class_2248 getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (class_2248)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public class_4970.class_2251 getLanternBlockProperties() {
        class_4970.class_2251 properties = class_4970.class_2251.method_9630((class_4970)class_2246.field_16541).method_9631(state -> LanternBlock.emitsLight(state) ? 15 : 0);
        return WEATHERING_BLOCKS.get((Object)this) == null ? properties : properties.method_9640();
    }

    public class_4970.class_2251 getChainBlockProperties() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_23985);
    }

    public void registerBlocks(RegistrationHandler.Helper<class_2248> helper) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        class_5955.class_5811 weathering = WEATHERING_BLOCKS.get((Object)this);
        this.lanternBlock = weathering == null ? new LanternBlock(this, null) : new WeatheringLanternBlock(this, null, weathering);
        helper.register(this.getSuffix() + "_lantern", (Object)this.lanternBlock);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = weathering == null ? new LanternBlock(this, color) : new WeatheringLanternBlock(this, color, weathering);
                this.coloredLanternBlocks.put(color, block);
                helper.register(color.getSuffix() + "_" + this.getSuffix() + "_lantern", (Object)block);
            }
        }
        if (this.hasChains) {
            this.chainBlock = weathering == null ? new ChainBlock(this) : new WeatheringChainBlock(this, weathering);
            helper.register(this.getSuffix() + "_chain", (Object)this.chainBlock);
        }
    }

    public void registerItems(RegistrationHandler.Helper<class_1792> helper) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.lanternItem = new BaseBlockItem((class_2248)this.lanternBlock, ItemProperties.create().group((class_1761)AdditionalLanterns.GROUP));
        if (this == NORMAL) {
            helper.registerOverride("minecraft", "lantern", (Object)this.lanternItem);
        } else {
            helper.register(this.getSuffix() + "_lantern", (Object)this.lanternItem);
        }
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                BaseBlockItem item = new BaseBlockItem((class_2248)block, ItemProperties.create().group((class_1761)AdditionalLanterns.GROUP));
                this.coloredLanternItems.put(color, (class_1792)item);
                helper.register(color.getSuffix() + "_" + this.getSuffix() + "_lantern", (Object)item);
            }
        }
        if (this.hasChains) {
            this.chainItem = new BaseBlockItem((class_2248)this.chainBlock, ItemProperties.create().group((class_1761)AdditionalLanterns.GROUP));
            helper.register(this.getSuffix() + "_chain", (Object)this.chainItem);
        }
    }

    static {
        WEATHERING_BLOCKS = ImmutableMap.builder().put((Object)COPPER, (Object)class_5955.class_5811.field_28704).put((Object)EXPOSED_COPPER, (Object)class_5955.class_5811.field_28705).put((Object)WEATHERED_COPPER, (Object)class_5955.class_5811.field_28706).put((Object)OXIDIZED_COPPER, (Object)class_5955.class_5811.field_28707).build();
    }
}

