/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.class_1923;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FleshTendonFeature
extends class_3031<class_3111> {
    protected SimpleBlockPredicate replace = (world, pos) -> class_2944.method_16420((class_3746)world, (class_2338)pos) || world.method_8320(pos).method_26204() == BOPBlocks.ROSE_QUARTZ_CLUSTER || world.method_8320(pos).method_26204() == BOPBlocks.LARGE_ROSE_QUARTZ_BUD || world.method_8320(pos).method_26204() == BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD || world.method_8320(pos).method_26204() == BOPBlocks.SMALL_ROSE_QUARTZ_BUD || world.method_8320(pos).method_26204() == BOPBlocks.FLESH_TENDONS_STRAND || world.method_8320(pos).method_26204() == BOPBlocks.FLESH_TENDONS || world.method_8320(pos).method_26204() == BOPBlocks.PUS_BUBBLE || world.method_8320(pos).method_26204() == BOPBlocks.HAIR || world.method_8320(pos).method_26204() == BOPBlocks.EYEBULB || world.method_8320(pos).method_26204() == BOPBlocks.BLOOD || world.method_8320(pos).method_26204() == class_2246.field_10164;
    private static final int MIN_DISTANCE = 8;
    private static final int MAX_DISTANCE = 32;
    private static final float MID_POS_MULTIPLIER = 0.9f;
    private static final float TENDON_STEP = 0.005f;

    public FleshTendonFeature(Codec<class_3111> deserializer) {
        super(deserializer);
    }

    private static class_2338 quadratic(float t, class_2338 v0, class_2338 v1, class_2338 v2) {
        float dt = 1.0f - t;
        class_243 v = new class_243((double)v0.method_10263(), (double)v0.method_10264(), (double)v0.method_10260()).method_1021((double)(dt * dt)).method_1019(new class_243((double)v1.method_10263(), (double)v1.method_10264(), (double)v1.method_10260()).method_1021((double)(2.0f * dt * t))).method_1019(new class_243((double)v2.method_10263(), (double)v2.method_10264(), (double)v2.method_10260()).method_1021((double)(t * t)));
        return class_2338.method_49637((double)v.field_1352, (double)v.field_1351, (double)v.field_1350);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_2338 curPos;
        class_5281 world = context.method_33652();
        class_5819 rand = context.method_33654();
        class_2338 pos = context.method_33655();
        int maxY = world.method_31607() + world.method_31605() - 1;
        class_2680 below = world.method_8320(pos.method_10074());
        if (!below.method_26164(ModTags.Blocks.FLESH)) {
            return false;
        }
        int xOff = rand.method_43048(64) - 32;
        int zOff = rand.method_43048(64) - 32;
        int minX = rand.method_43056() ? 8 : -8;
        int minZ = rand.method_43056() ? 8 : -8;
        class_2338 endPos = pos.method_10069(Math.abs(xOff) < 8 ? minX : xOff, pos.method_10264(), Math.abs(zOff) < 8 ? minZ : zOff);
        while (world.method_22347(endPos) && endPos.method_10264() < maxY) {
            endPos = endPos.method_10084();
        }
        if (endPos.method_10264() == pos.method_10264()) {
            return false;
        }
        class_2338 midPos = endPos.method_10069(0, class_3532.method_15375((float)((float)(-(endPos.method_10264() - pos.method_10264())) * 0.9f)), 0);
        for (float d = 0.0f; d < 1.0f && (curPos = FleshTendonFeature.quadratic(d, pos, midPos, endPos)).method_10264() < maxY; d += 0.005f) {
            class_2680 fleshBlock = BOPBlocks.FLESH.method_9564();
            if (rand.method_43048(5) == 0) {
                fleshBlock = BOPBlocks.POROUS_FLESH.method_9564();
            }
            this.setBlock(world, curPos, fleshBlock);
            if (rand.method_43048(75) == 0) {
                this.generateFleshBall(world, curPos, rand);
            }
            if (rand.method_43048(4) != 0) continue;
            this.placeFleshTendonColumn(world, rand, curPos.method_10074());
        }
        return true;
    }

    public boolean generateFleshBall(class_5281 world, class_2338 pos, class_5819 rand) {
        this.setBlock(world, pos, BOPBlocks.POROUS_FLESH.method_9564());
        this.setBlock(world, pos.method_10095(), class_2246.field_22122.method_9564(), 2);
        this.setBlock(world, pos.method_10072(), class_2246.field_22122.method_9564(), 2);
        this.setBlock(world, pos.method_10078(), class_2246.field_22122.method_9564(), 2);
        this.setBlock(world, pos.method_10067(), class_2246.field_22122.method_9564(), 2);
        this.setBlock(world, pos.method_10095().method_10067(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10072().method_10067(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10095().method_10078(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10072().method_10078(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10084(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10084().method_10095(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10084().method_10072(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10084().method_10078(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10084().method_10067(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10074(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10074().method_10095(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10074().method_10072(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10074().method_10078(), BOPBlocks.FLESH.method_9564());
        this.setBlock(world, pos.method_10074().method_10067(), BOPBlocks.FLESH.method_9564());
        this.placeFleshTendonColumn(world, rand, pos.method_10087(2));
        return true;
    }

    public void placeFleshTendonColumn(class_5281 p_67377_, class_5819 p_67378_, class_2338 p_67379_) {
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        blockpos$mutable.method_10101((class_2382)p_67379_);
        int rand = p_67378_.method_43048(6);
        int minHeight = rand == 0 ? 4 : 1;
        int maxHeight = rand == 0 ? 8 : 4;
        int height = class_3532.method_15395((class_5819)p_67378_, (int)minHeight, (int)maxHeight);
        if (p_67377_.method_8320(blockpos$mutable.method_10084()).method_26164(ModTags.Blocks.FLESH)) {
            class_2248 fleshCheck;
            for (int i = 0; i <= height && (fleshCheck = p_67377_.method_8320(blockpos$mutable.method_10074()).method_26204()) != BOPBlocks.FLESH_TENDONS && fleshCheck != BOPBlocks.FLESH_TENDONS_STRAND; ++i) {
                if (p_67377_.method_22347((class_2338)blockpos$mutable)) {
                    if (i == height || !p_67377_.method_22347(blockpos$mutable.method_10074())) {
                        this.setBlock(p_67377_, (class_2338)blockpos$mutable, BOPBlocks.FLESH_TENDONS.method_9564(), 2);
                        break;
                    }
                    this.setBlock(p_67377_, (class_2338)blockpos$mutable, BOPBlocks.FLESH_TENDONS_STRAND.method_9564(), 2);
                }
                blockpos$mutable.method_10098(class_2350.field_11033);
            }
        }
    }

    public boolean setBlock(class_5281 world, class_2338 pos, class_2680 state) {
        if (this.respectsCutoff((class_3233)world, pos) && this.replace.matches(world, pos)) {
            super.method_13153((class_1945)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean setBlock(class_5281 world, class_2338 pos, class_2680 state, int flags) {
        if (this.respectsCutoff((class_3233)world, pos) && this.replace.matches(world, pos)) {
            world.method_8652(pos, state, flags);
            return true;
        }
        return false;
    }

    private boolean respectsCutoff(class_3233 region, class_2338 pos) {
        int i = class_4076.method_18675((int)pos.method_10263());
        int j = class_4076.method_18675((int)pos.method_10260());
        class_1923 chunkpos = region.method_33561();
        int k = Math.abs(chunkpos.field_9181 - i);
        int l = Math.abs(chunkpos.field_9180 - j);
        return k <= region.field_33755 && l <= region.field_33755;
    }
}

