/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import net.darkhax.enchdesc.Constants;
import net.minecraft.class_124;
import net.minecraft.class_2583;

public class ConfigSchema {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(class_2583.class, (Object)new Serializer()).create();
    @Expose
    public boolean enableMod = true;
    @Expose
    public boolean onlyDisplayOnBooks = false;
    @Expose
    public boolean onlyDisplayInEnchantingTable = false;
    @Expose
    public boolean requireKeybindPress = false;
    @Expose
    public int indentSize = 0;
    @Expose
    public class_2583 style = class_2583.field_24360.method_10977(class_124.field_1063);

    public static ConfigSchema load(File configFile) {
        ConfigSchema config = new ConfigSchema();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (ConfigSchema)GSON.fromJson((Reader)reader, ConfigSchema.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.catching((Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return config;
    }

    private static class Serializer
    implements JsonSerializer<class_2583>,
    JsonDeserializer<class_2583> {
        private Serializer() {
        }

        public class_2583 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (class_2583)((Pair)class_2583.field_39241.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, error -> Constants.LOG.error("Error parsing style config: {}", error))).getFirst();
        }

        public JsonElement serialize(class_2583 src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)class_2583.field_39241.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src).getOrThrow(false, error -> Constants.LOG.error("Error writing style config: {}", error));
        }
    }
}

