/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5575;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), storageWrapper::getInventoryHandler, storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public class_1799 pickup(class_1937 world, class_1799 stack, TransactionContext ctx) {
        if (!this.shouldPickupItems() || !this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        ItemVariant resource = ItemVariant.of((class_1799)stack);
        long inserted = this.storageWrapper.getInventoryForUpgradeProcessing().insert(resource, stack.method_7947(), ctx);
        return resource.toStack(stack.method_7947() - (int)inserted);
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        int cooldown;
        if (this.isInCooldown(world)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, world, pos) : 40;
        if (this.shouldPickupXp() && this.canFillStorageWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, world, pos));
        }
        this.setCooldown(world, cooldown);
    }

    private boolean canFillStorageWithXp() {
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.simulateInsert(ModFluids.EXPERIENCE_TAG, 81000L, (class_3611)ModFluids.XP_STILL, null) > 0L).orElse(false);
    }

    private int pickupXpOrbs(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        List xpEntities = world.method_8390(class_1303.class, new class_238(pos).method_1014((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        for (class_1303 xpOrb : xpEntities) {
            if (!xpOrb.method_5805() || this.canNotPickup((class_1297)xpOrb, entity) || this.tryToFillTank(xpOrb, entity, world)) continue;
            cooldown = 40;
            break;
        }
        return cooldown;
    }

    private boolean tryToFillTank(class_1303 xpOrb, @Nullable class_1309 entity, class_1937 world) {
        long amountToTransfer = XpHelper.experienceToLiquid(xpOrb.method_5919());
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> {
            long amountAdded;
            try (Transaction outer = Transaction.openOuter();){
                amountAdded = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, amountToTransfer, (class_3611)ModFluids.XP_STILL, (TransactionContext)outer);
                outer.commit();
            }
            if (amountAdded > 0L) {
                class_243 pos = xpOrb.method_19538();
                xpOrb.method_31472();
                class_1657 player = (class_1657)entity;
                if (player != null) {
                    MagnetUpgradeWrapper.playXpPickupSound(world, player);
                }
                if (amountToTransfer > amountAdded) {
                    world.method_8649((class_1297)new class_1303(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), (int)XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        List itemEntities = world.method_18023((class_5575)class_1299.field_6052, new class_238(pos).method_1014((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        class_1657 player = (class_1657)entity;
        for (class_1542 itemEntity : itemEntities) {
            if (!itemEntity.method_5805() || !this.filterLogic.matchesFilter(itemEntity.method_6983()) || this.canNotPickup((class_1297)itemEntity, entity)) continue;
            if (this.tryToInsertItem(itemEntity)) {
                if (player == null) continue;
                MagnetUpgradeWrapper.playItemPickupSound(world, player);
                continue;
            }
            cooldown = 40;
        }
        return cooldown;
    }

    private static void playItemPickupSound(class_1937 world, @Nonnull class_1657 player) {
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, (world.field_9229.method_43057() - world.field_9229.method_43057()) * 1.4f + 2.0f);
    }

    private static void playXpPickupSound(class_1937 world, @Nonnull class_1657 player) {
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14627, class_3419.field_15248, 0.1f, (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.35f + 0.9f);
    }

    private boolean isBlockedBySomething(class_1297 entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(class_1297 entity, @Nullable class_1309 player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        class_2487 data = entity.getSophisticatedCustomData();
        return player != null ? data.method_10545(PREVENT_REMOTE_MOVEMENT) : data.method_10545(PREVENT_REMOTE_MOVEMENT) && !data.method_10545(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        ItemVariant resource = ItemVariant.of((class_1799)stack);
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        try (Transaction ctx = Transaction.openOuter();){
            long inserted = inventory.insert(resource, stack.method_7947(), (TransactionContext)ctx);
            if (inserted > 0L) {
                itemEntity.method_6979(resource.toStack(stack.method_7947() - (int)inserted));
                ctx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void setPickupItems(boolean pickupItems) {
        NBTHelper.setBoolean(this.upgrade, "pickupItems", pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return NBTHelper.getBoolean(this.upgrade, "pickupItems").orElse(true);
    }

    public void setPickupXp(boolean pickupXp) {
        NBTHelper.setBoolean(this.upgrade, "pickupXp", pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return NBTHelper.getBoolean(this.upgrade, "pickupXp").orElse(true);
    }
}

