/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5916;
import net.p3pp3rf1y.porting_lib.transfer.items.SCSlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.TemplatePersistanceContainer;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor.AbstractContainerMenuAccessor;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncAdditionalSlotInfoMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncEmptySlotIconsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncTemplateSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsContainer;

public abstract class SettingsContainerMenu<S extends IStorageWrapper>
extends class_1703
implements ISyncedContainer,
IAdditionalSlotInfoMenu {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES = new HashMap();
    protected final class_1657 player;
    protected final S storageWrapper;
    private final List<class_1735> storageInventorySlots = new ArrayList<class_1735>();
    public final class_2371<class_1799> lastGhostSlots = class_2371.method_10211();
    public final class_2371<class_1799> remoteGhostSlots = class_2371.method_10211();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    private final TemplatePersistanceContainer templatePersistanceContainer;
    public final List<class_1735> ghostSlots = new ArrayList<class_1735>();
    private boolean inventorySlotStackChanged = false;
    private final Set<Integer> inaccessibleSlots = new HashSet<Integer>();
    private final Map<Integer, class_1799> slotFilterItems = new HashMap<Integer, class_1799>();
    private final Map<Integer, Pair<class_2960, class_2960>> emptySlotIcons = new HashMap<Integer, Pair<class_2960, class_2960>>();

    protected SettingsContainerMenu(class_3917<?> menuType, int windowId, class_1657 player, S storageWrapper) {
        super(menuType, windowId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.addStorageInventorySlots();
        this.addSettingsContainers();
        this.templatePersistanceContainer = new TemplatePersistanceContainer(this);
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().getSlotCount();
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    private void addSettingsContainers() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainerMenu.instantiateContainer(this, name, category)));
    }

    private void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slotIndex = 0;
        while (slotIndex < inventoryHandler.getSlotCount()) {
            int finalSlotIndex = slotIndex++;
            this.storageInventorySlots.add(this.method_7621(new ViewOnlyStorageInventorySlot(inventoryHandler, finalSlotIndex)));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    protected class_1735 method_7621(class_1735 slot) {
        slot.field_7874 = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.lastGhostSlots.add((Object)class_1799.field_8037);
        this.remoteGhostSlots.add((Object)class_1799.field_8037);
        return slot;
    }

    public void method_7623() {
        for (int slot = 0; slot < this.ghostSlots.size(); ++slot) {
            class_1799 itemstack = this.ghostSlots.get(slot).method_7677();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((class_1799)itemstack).method_7972());
            this.triggerSlotListeners(slot, itemstack, (Supplier<class_1799>)supplier);
            this.synchronizeSlotToRemote(slot, itemstack, (Supplier<class_1799>)supplier);
        }
        if (this.inventorySlotStackChanged) {
            this.inventorySlotStackChanged = false;
            this.sendAdditionalSlotInfo();
        }
    }

    public void method_37420() {
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            class_1799 itemstack = this.ghostSlots.get(slotIndex).method_7677();
            this.triggerSlotListeners(slotIndex, itemstack, () -> ((class_1799)itemstack).method_7972());
        }
        this.method_34252();
    }

    private void triggerSlotListeners(int slotIndex, class_1799 slotStack, Supplier<class_1799> slotStackCopy) {
        class_1799 itemstack = (class_1799)this.lastGhostSlots.get(slotIndex);
        if (!class_1799.method_7973((class_1799)itemstack, (class_1799)slotStack)) {
            class_1799 itemstack1 = slotStackCopy.get();
            this.lastGhostSlots.set(slotIndex, (Object)itemstack1);
            for (class_1712 containerlistener : ((AbstractContainerMenuAccessor)((Object)this)).getContainerListeners()) {
                containerlistener.method_7635((class_1703)this, slotIndex, itemstack1);
            }
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, class_1799 slotStack, Supplier<class_1799> slotStackCopy) {
        class_1799 remoteStack;
        if (!((AbstractContainerMenuAccessor)((Object)this)).getSuppressRemoteUpdates() && !class_1799.method_7973((class_1799)(remoteStack = (class_1799)this.remoteGhostSlots.get(slotIndex)), (class_1799)slotStack)) {
            class_1799 stackCopy = slotStackCopy.get();
            this.remoteGhostSlots.set(slotIndex, (Object)stackCopy);
            if (remoteStack.method_7960() || slotStack.method_7960()) {
                this.inventorySlotStackChanged = true;
            }
            if (((AbstractContainerMenuAccessor)((Object)this)).getSynchronizer() != null) {
                ((AbstractContainerMenuAccessor)((Object)this)).getSynchronizer().method_34261((class_1703)this, slotIndex, stackCopy);
            }
        }
    }

    public int getNumberOfSlots() {
        return this.storageWrapper.getInventoryHandler().getSlotCount();
    }

    public void method_34252() {
        class_1657 class_16572;
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            this.remoteGhostSlots.set(slotIndex, (Object)this.ghostSlots.get(slotIndex).method_7677().method_7972());
        }
        if (((AbstractContainerMenuAccessor)((Object)this)).getSynchronizer() != null) {
            ((AbstractContainerMenuAccessor)((Object)this)).getSynchronizer().method_34263((class_1703)this, this.remoteGhostSlots, ((AbstractContainerMenuAccessor)((Object)this)).getRemoteCarried(), new int[0]);
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
            PacketHandler.sendToClient(serverPlayer, new SyncTemplateSettingsMessage(settingsTemplateStorage.getPlayerTemplates((class_1657)serverPlayer), settingsTemplateStorage.getPlayerNamedTemplates((class_1657)serverPlayer)));
        }
        this.sendEmptySlotIcons();
        this.sendAdditionalSlotInfo();
    }

    public abstract void detectSettingsChangeAndReload();

    public void method_34248(class_5916 synchronizer) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (this.storageWrapper.getInventoryHandler().getStackSizeMultiplier() > 1.0) {
                super.method_34248((class_5916)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.method_34248(synchronizer);
    }

    public class_1735 method_7611(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public void onMemorizedStackAdded(int slotNumber) {
        this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
        this.sendAdditionalSlotInfo();
    }

    public void onMemorizedStackRemoved(int slotNumber) {
        if (this.method_7611(slotNumber).method_7677().method_7960()) {
            this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(slotNumber);
            this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
            this.sendAdditionalSlotInfo();
        }
    }

    public void onMemorizedItemsChanged() {
        this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemsChanged();
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public List<class_1735> getStorageInventorySlots() {
        return this.storageInventorySlots;
    }

    @Override
    public void handleMessage(class_2487 data) {
        if (data.method_10545("categoryName")) {
            String categoryName = data.method_10558("categoryName");
            if (this.settingsContainers.containsKey(categoryName)) {
                this.settingsContainers.get(categoryName).handleMessage(data);
            }
        } else if (data.method_10573("templatePersistance", 10)) {
            this.templatePersistanceContainer.handleMessage(data.method_10562("templatePersistance"));
        }
    }

    public void method_7593(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player) {
    }

    public class_1799 method_7601(class_1657 pPlayer, int pIndex) {
        return class_1799.field_8037;
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public class_2338 getBlockPosition() {
        return class_2338.field_10980;
    }

    public <T extends ISettingsCategory<?>> Optional<T> getSelectedTemplatesCategory(Class<T> categoryClass) {
        return this.templatePersistanceContainer.getSelectedTemplate().map(selectedTemplate -> selectedTemplate.getTypeCategory(categoryClass));
    }

    public TemplatePersistanceContainer getTemplatePersistanceContainer() {
        return this.templatePersistanceContainer;
    }

    public void refreshTemplateSlots() {
        this.templatePersistanceContainer.refreshTemplateSlots();
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    protected static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(String categoryName, ISettingsContainerFactory<C, T> factory) {
        SETTINGS_CONTAINER_FACTORIES.put(categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainerMenu<?> settingsContainer, String name, C category) {
        return SettingsContainerMenu.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    public void sendDataToServer(Supplier<class_2487> supplyData) {
        if (this.isServer()) {
            return;
        }
        class_2487 data = supplyData.get();
        PacketHandler.sendToServer(new SyncContainerClientDataMessage(data));
    }

    protected boolean isServer() {
        return !this.player.method_37908().field_9236;
    }

    public void sendAdditionalSlotInfo() {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        HashSet<Integer> inaccessibleSlots = new HashSet<Integer>();
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        HashMap<Integer, class_1792> slotFilterItems = new HashMap<Integer, class_1792>();
        for (int slot = 0; slot < inventoryHandler.getSlotCount(); ++slot) {
            if (!inventoryHandler.isSlotAccessible(slot)) {
                inaccessibleSlots.add(slot);
            }
            if (inventoryHandler.getFilterItem(slot) == class_1802.field_8162) continue;
            slotFilterItems.put(slot, inventoryHandler.getFilterItem(slot));
        }
        PacketHandler.sendToClient(serverPlayer, new SyncAdditionalSlotInfoMessage(inaccessibleSlots, Map.of(), slotFilterItems));
    }

    @Override
    public void updateAdditionalSlotInfo(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Map<Integer, class_1792> slotFilterItems) {
        this.inaccessibleSlots.clear();
        this.inaccessibleSlots.addAll(inaccessibleSlots);
        this.slotFilterItems.clear();
        slotFilterItems.forEach((slot, item) -> this.slotFilterItems.put((Integer)slot, new class_1799((class_1935)item)));
    }

    @Override
    public void updateEmptySlotIcons(Map<class_2960, Set<Integer>> emptySlotIcons) {
        this.emptySlotIcons.clear();
        emptySlotIcons.forEach((textureName, slots) -> slots.forEach(slot -> this.emptySlotIcons.put((Integer)slot, (Pair<class_2960, class_2960>)new Pair((Object)class_1723.field_21668, textureName))));
    }

    public void method_37449(int slot, class_1799 stack) {
        class_1799 previous = this.method_7611(slot).method_7677();
        super.method_37449(slot, stack);
        if (previous.method_7960() || stack.method_7960()) {
            this.inventorySlotStackChanged = true;
        }
    }

    private void sendEmptySlotIcons() {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        HashMap<class_2960, Set<Integer>> noItemSlotTextures = new HashMap<class_2960, Set<Integer>>();
        for (int slot = 0; slot < this.storageWrapper.getInventoryHandler().getSlotCount(); ++slot) {
            Pair<class_2960, class_2960> noItemIcon = this.storageWrapper.getInventoryHandler().getNoItemIcon(slot);
            if (noItemIcon == null) continue;
            noItemSlotTextures.computeIfAbsent((class_2960)noItemIcon.getSecond(), rl -> new HashSet()).add(slot);
        }
        PacketHandler.sendToClient(serverPlayer, new SyncEmptySlotIconsMessage(noItemSlotTextures));
    }

    public class_1799 getSlotFilterItem(int slot) {
        return this.slotFilterItems.getOrDefault(slot, class_1799.field_8037);
    }

    static {
        SettingsContainerMenu.addFactory("global", MainSettingsContainer::new);
        SettingsContainerMenu.addFactory("no_sort", NoSortSettingsContainer::new);
        SettingsContainerMenu.addFactory("memory", MemorySettingsContainer::new);
        SettingsContainerMenu.addFactory("item_display", ItemDisplaySettingsContainer::new);
    }

    private class ViewOnlyStorageInventorySlot
    extends SCSlotItemHandler {
        public ViewOnlyStorageInventorySlot(SlottedStackStorage inventoryHandler, int slotIndex) {
            super(inventoryHandler, slotIndex, 0, 0);
        }

        @Override
        public boolean method_7674(class_1657 playerIn) {
            return false;
        }

        @Nullable
        public Pair<class_2960, class_2960> method_7679() {
            return SettingsContainerMenu.this.inaccessibleSlots.contains(this.method_34266()) ? StorageContainerMenuBase.INACCESSIBLE_SLOT_BACKGROUND : (Pair)SettingsContainerMenu.this.emptySlotIcons.getOrDefault(this.method_34266(), null);
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainerMenu<?> var1, String var2, C var3);
    }
}

