/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TranslationHelper {
    public static final String TOOLTIP_SUFFIX = ".tooltip";
    private static final String BUTTONS_SUFFIX = "buttons.";
    private static final String MESSAGE_SUFFIX = "message.";
    private static final String CONTROLS_SUFFIX = "controls.";
    public static final TranslationHelper INSTANCE = new TranslationHelper("sophisticatedcore");
    private final String guiPrefix;
    private final String guiUpgradePrefix;
    private final String guiSettingsPrefix;
    private final String guiStatusPrefix;
    private final String buttonsPrefix;
    private final String itemUpgradePrefix;
    private final String blockPrefix;
    private final String upgradeGroupPrefix;
    private final String upgradeButtonsPrefix;
    private final String upgradeControlsPrefix;
    private final String keybindPrefix;

    public TranslationHelper(String modId) {
        this.guiPrefix = "gui." + modId + ".";
        this.keybindPrefix = "keybind." + modId + ".";
        this.itemUpgradePrefix = "item." + modId + ".";
        this.blockPrefix = "block." + modId + ".";
        this.upgradeGroupPrefix = "upgrade_group." + modId + ".";
        this.guiUpgradePrefix = this.guiPrefix + "upgrades.";
        this.guiSettingsPrefix = this.guiPrefix + "settings.";
        this.guiStatusPrefix = this.guiPrefix + "status.";
        this.buttonsPrefix = this.guiPrefix + BUTTONS_SUFFIX;
        this.upgradeButtonsPrefix = this.guiUpgradePrefix + BUTTONS_SUFFIX;
        this.upgradeControlsPrefix = this.guiUpgradePrefix + CONTROLS_SUFFIX;
    }

    public class_2561 translStatusMessage(String statusMessage, Object ... params) {
        return class_2561.method_43469((String)(this.guiStatusPrefix + statusMessage), (Object[])params);
    }

    public class_5250 translUpgrade(String upgradeName, Object ... params) {
        return class_2561.method_43469((String)this.translUpgradeKey(upgradeName), (Object[])params);
    }

    public class_2561 translUpgradeSlotTooltip(String tooltipName) {
        return class_2561.method_43471((String)(this.guiUpgradePrefix + "slots." + tooltipName + TOOLTIP_SUFFIX));
    }

    public String translUpgradeKey(String upgradeName) {
        return this.guiUpgradePrefix + upgradeName;
    }

    public String translBlockTooltipKey(String blockName) {
        return this.blockPrefix + blockName + TOOLTIP_SUFFIX;
    }

    public String translSettings(String categoryName) {
        return this.guiSettingsPrefix + categoryName;
    }

    public String translSettingsButton(String buttonName) {
        return this.translSettings(BUTTONS_SUFFIX + buttonName);
    }

    public String translSettingsMessage(String messageName) {
        return this.translSettings(MESSAGE_SUFFIX + messageName);
    }

    public class_2561 translUpgradeTooltip(String upgradeName) {
        return class_2561.method_43471((String)(this.translUpgradeKey(upgradeName) + TOOLTIP_SUFFIX));
    }

    public String translSettingsTooltip(String categoryName) {
        return this.translSettings(categoryName) + TOOLTIP_SUFFIX;
    }

    public class_2561 translColoredButton(String buttonName, class_124 color) {
        return class_2561.method_43471((String)this.translButton(buttonName)).method_27692(color);
    }

    public String translButton(String buttonName) {
        return this.buttonsPrefix + buttonName;
    }

    public class_2561 translError(String key, Object ... params) {
        return class_2561.method_43469((String)(this.guiPrefix + "error." + key), (Object[])params);
    }

    public String translUpgradeGroup(String groupName) {
        return this.upgradeGroupPrefix + groupName;
    }

    public String translUpgradeButton(String buttonName) {
        return this.upgradeButtonsPrefix + buttonName;
    }

    public String translUpgradeControl(String controlName) {
        return this.upgradeControlsPrefix + controlName;
    }

    public String translItemTooltip(String itemName) {
        return this.itemUpgradePrefix + itemName + TOOLTIP_SUFFIX;
    }

    public List<class_2561> getTranslatedLines(String translateKey, @Nullable Object parameters, class_124 ... textFormattings) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        for (class_2561 translatedLine : this.getTranslatedLines(translateKey, parameters)) {
            if (!(translatedLine instanceof class_5250)) continue;
            class_5250 mutableComponent = (class_5250)translatedLine;
            mutableComponent.method_27695(textFormattings);
            ret.add(translatedLine);
        }
        return ret;
    }

    public List<class_2561> getTranslatedLines(String translateKey) {
        return this.getTranslatedLines(translateKey, null);
    }

    public List<class_2561> getTranslatedLines(String translateKey, @Nullable Object parameters) {
        String text = this.translate(translateKey, parameters);
        String[] lines = text.split("\n");
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        for (String line : lines) {
            ret.add((class_2561)class_2561.method_43470((String)line));
        }
        return ret;
    }

    public String translate(String translateKey, Object ... parameters) {
        return class_1074.method_4662((String)translateKey, (Object[])parameters);
    }

    public String translKeybind(String keybindName) {
        return this.keybindPrefix + keybindName;
    }

    public String translGui(String guiTranslateKey) {
        return this.guiPrefix + guiTranslateKey;
    }

    public String translGuiTooltip(String guiTranslateKey) {
        return this.guiPrefix.substring(0, this.guiPrefix.length() - 1) + ".tooltip." + guiTranslateKey;
    }
}

