/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.renderers.items.LunchBoxItemRenderer;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.fabric.LunchBoxItemImpl;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4174;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends SelectableContainerItem<Data>
implements ICustomItemRendererProvider,
ILeftClickReact {
    public LunchBoxItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7851(class_1799 pStack, class_1937 level, List<class_2561> list, class_1836 pIsAdvanced) {
        Data data;
        super.method_7851(pStack, level, list, pIsAdvanced);
        if (MiscUtils.showsHints((class_1922)level, pIsAdvanced)) {
            LunchBoxItem.addClientTooltip(list);
        }
        if ((data = this.getData(pStack)) != null) {
            boolean open = data.canEatFrom();
            list.add((class_2561)(open ? class_2561.method_43471((String)"message.supplementaries.lunch_box.tooltip.open") : class_2561.method_43471((String)"message.supplementaries.lunch_box.tooltip.closed")));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void addClientTooltip(List<class_2561> list) {
        list.add((class_2561)class_2561.method_43469((String)"message.supplementaries.lunch_box.tooltip", (Object[])new Object[]{class_310.method_1551().field_1690.field_1886.method_16007()}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 player, class_1268 hand) {
        class_1799 basket = player.method_5998(hand);
        Data data = this.getData(basket);
        if (data.canEatFrom()) {
            class_1799 food = data.getSelected();
            if (food.method_7960()) {
                return class_1271.method_22431((Object)basket);
            }
            player.method_6122(hand, food);
            class_1271 result = food.method_7913(pLevel, player, hand);
            ((LivingEntityAccessor)player).setUseItem(basket);
            player.method_6122(hand, basket);
            return new class_1271(result.method_5467(), (Object)basket);
        }
        return super.method_7836(pLevel, player, hand);
    }

    public boolean onLeftClick(class_1799 stack, class_1657 player, class_1268 hand) {
        Data data = this.getData(stack);
        boolean open = data.canEatFrom();
        if (open) {
            player.method_5783(ModSounds.LUNCH_BASKET_CLOSE.get(), 0.3f, 1.0f + player.method_37908().method_8409().method_43057() * 0.3f);
        } else {
            player.method_5783(ModSounds.LUNCH_BASKET_OPEN.get(), 0.3f, 1.6f + player.method_37908().method_8409().method_43057() * 0.3f);
        }
        data.switchMode();
        return true;
    }

    public boolean method_7885(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return false;
    }

    @Nullable
    public class_4174 getFoodProperties(class_1799 stack, @Nullable class_1309 entity) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return SuppPlatformStuff.getFoodProperties(data.getSelected(), entity);
        }
        return super.method_19264();
    }

    @Override
    public int method_7881(class_1799 stack) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return data.getSelected().method_7935();
        }
        return super.method_7881(stack);
    }

    public class_1839 method_7853(class_1799 stack) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            return data.getSelected().method_7976();
        }
        return super.method_7853(stack);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        Data data = this.getData(stack);
        if (data.canEatFrom()) {
            class_1799 selected = data.getSelected();
            class_1799 copy = selected.method_46651(1);
            class_1799 result = copy.method_7910(level, livingEntity);
            if (result.method_7960()) {
                data.consumeSelected();
            } else if (result != copy) {
                class_1657 p;
                data.consumeSelected();
                class_1799 remaining = data.tryAdding(result);
                if (!remaining.method_7960() && livingEntity instanceof class_1657 && !(p = (class_1657)livingEntity).method_31548().method_7394(remaining)) {
                    p.method_7328(remaining, false);
                }
            }
            return stack;
        }
        return super.method_7861(stack, level, livingEntity);
    }

    @Override
    protected void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(ModSounds.LUNCH_BASKET_INSERT.get(), 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public Supplier<ItemStackRenderer> getRendererFactory() {
        return LunchBoxItemRenderer::new;
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.LUNCH_BOX_SLOTS.get();
    }

    @Override
    public Data getData(class_1799 stack) {
        return LunchBoxItem.getLunchBoxData(stack);
    }

    @NotNull
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getLunchBoxData(class_1799 stack) {
        return LunchBoxItemImpl.getLunchBoxData(stack);
    }

    @NotNull
    public static class_1799 findActiveLunchBox(class_1309 entity) {
        return LunchBoxItem.findActiveLunchBoxSlot(entity).get(entity);
    }

    @NotNull
    public static SlotReference findActiveLunchBoxSlot(class_1309 entity) {
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.method_7909() instanceof LunchBoxItem);
    }

    public static boolean canAcceptItem(class_1799 toInsert) {
        if (!toInsert.method_7909().method_31568()) {
            return false;
        }
        if (toInsert.method_31573(ModTags.LUNCH_BASKET_BLACKLIST)) {
            return false;
        }
        class_1839 animation = toInsert.method_7909().method_7853(toInsert);
        return animation == class_1839.field_8946 || animation == class_1839.field_8950;
    }

    public static interface Data
    extends SelectableContainerItem.AbstractData {
        @Override
        default public boolean canAcceptItem(class_1799 toInsert) {
            return LunchBoxItem.canAcceptItem(toInsert);
        }

        public boolean canEatFrom();

        public void switchMode();
    }
}

