/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.hud.fabric.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleSelectableContainerItemPacket;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerItemHud {
    public static SelectableContainerItemHud INSTANCE = SelectableContainerItemHud.makeInstance();
    protected final class_310 mc;
    @Nullable
    private SelectableContainerItem<?> itemUsed;
    private SlotReference stackSlot;
    private boolean usingKey = false;
    private double lastCumulativeMouseDx = 0.0;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SelectableContainerItemHud makeInstance() {
        return SelectableContainerItemHudImpl.makeInstance();
    }

    protected SelectableContainerItemHud(class_310 minecraft) {
        this.mc = minecraft;
    }

    public boolean isActive() {
        return this.itemUsed != null;
    }

    public boolean isUsingKey() {
        return this.itemUsed != null && this.usingKey;
    }

    public boolean isUsingItem() {
        return this.itemUsed != null && !this.usingKey;
    }

    public void setUsingItem(SlotReference slot, class_1309 player) {
        SelectableContainerItem selectable;
        this.stackSlot = slot;
        class_1792 class_17922 = slot.getItem(player);
        this.itemUsed = class_17922 instanceof SelectableContainerItem ? (selectable = (SelectableContainerItem)class_17922) : null;
    }

    public void setUsingKeybind(SlotReference slot, class_1657 player) {
        this.setUsingItem(slot, (class_1309)player);
        this.usingKey = this.itemUsed != null;
    }

    private void closeHud() {
        this.itemUsed = null;
        this.usingKey = false;
        this.stackSlot = SlotReference.EMPTY;
    }

    public boolean onMouseScrolled(double scrollDelta) {
        if (this.itemUsed != null) {
            int amount = scrollDelta > 0.0 ? -1 : 1;
            this.sendCycle(amount);
            return true;
        }
        return false;
    }

    public void ohMouseMoved(double deltaX) {
        if (this.itemUsed != null && ClientConfigs.Items.QUIVER_MOUSE_MOVEMENT.get().booleanValue()) {
            class_746 player;
            double scale = (Double)class_310.method_1551().field_1690.method_42495().method_41753() * 0.02;
            int oldI = (int)(this.lastCumulativeMouseDx * scale);
            this.lastCumulativeMouseDx += deltaX;
            int slotsMoved = (int)(this.lastCumulativeMouseDx * scale) - oldI;
            if (slotsMoved != 0 && (player = class_310.method_1551().field_1724) != null) {
                this.sendCycle(slotsMoved);
            }
        }
    }

    private void sendCycle(int slotsMoved) {
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data != null) {
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleSelectableContainerItemPacket(slotsMoved, this.stackSlot));
            data.cycle(slotsMoved);
        }
    }

    private void sendSetSlot(int number) {
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data != null) {
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleSelectableContainerItemPacket(number, this.stackSlot, true));
            this.getItemUsedData().setSelectedSlot(number);
        }
    }

    public boolean onKeyPressed(int key, int action, int modifiers) {
        if (this.itemUsed == null) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        switch (key) {
            case 263: {
                this.sendCycle(-1);
                return true;
            }
            case 262: {
                this.sendCycle(1);
                return true;
            }
        }
        int number = key - 48;
        if (number >= 1 && number <= 9) {
            if (number <= this.itemUsed.getMaxSlots()) {
                this.sendSetSlot(number - 1);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private SelectableContainerItem.AbstractData getItemUsedData() {
        if (this.itemUsed == null) {
            return null;
        }
        class_1799 stack = this.stackSlot.get((class_1309)class_310.method_1551().field_1724);
        if (!stack.method_31574(this.itemUsed)) {
            return null;
        }
        return this.itemUsed.getData(stack);
    }

    public void render(class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        boolean keyDown;
        if (this.itemUsed == null) {
            return;
        }
        if (!(this.mc.method_1560() instanceof IQuiverPlayer)) {
            this.closeHud();
            return;
        }
        if (this.isUsingKey() && !ClientRegistry.QUIVER_KEYBIND.method_1415() && !(keyDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)ClientRegistry.QUIVER_KEYBIND.field_1655.method_1444()))) {
            this.closeHud();
            return;
        }
        SelectableContainerItem.AbstractData data = this.getItemUsedData();
        if (data == null) {
            this.closeHud();
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        int selected = data.getSelectedSlot();
        List<class_1799> items = data.getContentView();
        int slots = items.size();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int centerX = screenWidth / 2;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, -90.0f);
        int uWidth = slots * 20 + 2;
        int px = uWidth / 2;
        int py = screenHeight / 2 - 40;
        graphics.method_25302(ModTextures.QUIVER_HUD, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), 0, 0, uWidth - 1, 22);
        graphics.method_25302(ModTextures.QUIVER_HUD, centerX + px - 1, py, 0, 0, 1, 22);
        graphics.method_25302(ModTextures.QUIVER_HUD, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
        poseStack.method_22909();
        int i1 = 1;
        for (int i = 0; i < slots; ++i) {
            int kx = centerX - px + 3 + i * 20;
            this.renderSlot(graphics, kx, py + 3, items.get(i), i1++, this.mc.field_1772);
        }
        RenderSystem.disableBlend();
        class_1799 selectedArrow = items.get(selected);
        if (!selectedArrow.method_7960()) {
            this.drawHighlight(graphics, screenWidth, py, selectedArrow);
        }
        poseStack.method_22909();
    }

    private void renderSlot(class_332 graphics, int pX, int pY, class_1799 pStack, int seed, class_327 font) {
        if (!pStack.method_7960()) {
            graphics.method_51428(pStack, pX, pY, seed);
            RenderSystem.setShader(class_757::method_34540);
            graphics.method_51431(font, pStack, pX, pY);
        }
    }

    protected abstract void drawHighlight(class_332 var1, int var2, int var3, class_1799 var4);
}

