/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.SwingWorker;

public class Downloader
extends SwingWorker<Void, Void> {
    private final String url;
    private final File file;

    public Downloader(String url, File file) {
        this.url = url;
        this.file = file;
    }

    @Override
    protected Void doInBackground() throws Exception {
        URL url = new URL(this.url);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        long filesize = connection.getContentLengthLong();
        if (filesize == -1L) {
            throw new Exception("Content length must not be -1 (unknown)!");
        }
        long totalDataRead = 0L;
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
            FileOutputStream fos = new FileOutputStream(this.file);
            try (BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);){
                int i;
                byte[] data = new byte[1024];
                while ((i = in.read(data, 0, 1024)) >= 0) {
                    bout.write(data, 0, i);
                    int percent = (int)((totalDataRead += (long)i) * 100L / filesize);
                    this.setProgress(percent);
                }
            }
        }
        return null;
    }
}

