/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import net.minecraft.class_5712;

public class LiquidCauldronBlockTile
extends class_2586
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = new ModelDataKey(class_5321.class);
    public static final ModelDataKey<Boolean> GLOWING = new ModelDataKey(Boolean.class);
    private final SoftFluidTank fluidTank;
    private boolean hasGlowInk = false;

    public SoftFluidTank makeTank(class_2680 blockState) {
        return blockState.method_26204() instanceof DyeCauldronBlock ? this.createCauldronDyeTank() : this.createCauldronLiquidTank();
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.method_11010().method_11654((class_2769)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(class_2338 blockPos, class_2680 blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)((class_5321)this.fluidTank.getFluid().getHolder().method_40230().get()));
        builder.with(GLOWING, (Object)this.hasGlowInk);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.fluidTank.load(compound);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
        this.hasGlowInk = compound.method_10577("glow_ink");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.fluidTank.save(tag);
        if (this.hasGlowInk) {
            tag.method_10556("glow_ink", true);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)class_22482;
            state = cb.updateStateOnFluidChange(state, this.field_11863, this.field_11867, this.fluidTank.getFluid());
        }
        if (state != this.method_11010()) {
            this.field_11863.method_8501(this.field_11867, state);
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), state, 2);
        super.method_5431();
    }

    public boolean handleInteraction(class_1657 player, class_1268 hand) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.field_11863, this.field_11867)) {
            this.field_11863.method_33596((class_1297)player, class_5712.field_28733, this.field_11867);
            this.method_5431();
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.method_5431();
    }

    public SoftFluidTank createCauldronLiquidTank() {
        return new SoftFluidTank(PlatHelper.getPlatform().isFabric() ? 3 : 4){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)BuiltInSoftFluids.WATER.get())) {
                    return false;
                }
                if (LiquidCauldronBlockTile.this.canMixPotions() && fluidStack.is((SoftFluid)BuiltInSoftFluids.POTION.get()) && fluidStack.is(this.getFluidValue())) {
                    return this.fluidStack.getTag().method_10558("Bottle").equals(fluidStack.getTag().method_10558("Bottle"));
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                if (LiquidCauldronBlockTile.this.canMixPotions() && incoming.is((SoftFluid)BuiltInSoftFluids.POTION.get())) {
                    LiquidMixer.mixPotions(this.fluidStack, incoming);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTank(3){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get()) && fluidStack.is(this.getFluidValue())) {
                    return true;
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                    LiquidMixer.mixDye(this.fluidStack, fluidStack);
                }
                super.addFluidOntoExisting(fluidStack);
            }
        };
    }

    public boolean isGlowing() {
        return this.hasGlowInk;
    }

    public void setGlowing(boolean b) {
        this.hasGlowInk = b;
        this.method_5431();
    }
}

