/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.client.ClientResourceGenerator;
import net.mehvahdjukaar.amendments.client.ItemHoldingAnimationsManager;
import net.mehvahdjukaar.amendments.client.WallLanternModelsManager;
import net.mehvahdjukaar.amendments.client.colors.BrewingStandColor;
import net.mehvahdjukaar.amendments.client.colors.CrossbowColor;
import net.mehvahdjukaar.amendments.client.colors.MimicBlockColor;
import net.mehvahdjukaar.amendments.client.colors.SoftFluidColor;
import net.mehvahdjukaar.amendments.client.gui.LecternBookEditScreen;
import net.mehvahdjukaar.amendments.client.model.CarpetedBlockModel;
import net.mehvahdjukaar.amendments.client.model.CauldronModelLoader;
import net.mehvahdjukaar.amendments.client.model.HangingPotBakedModel;
import net.mehvahdjukaar.amendments.client.model.SkullCandleOverlayModel;
import net.mehvahdjukaar.amendments.client.model.ToolHookBakedModel;
import net.mehvahdjukaar.amendments.client.model.WallLanternBakedModel;
import net.mehvahdjukaar.amendments.client.model.WaterloggedLilyModel;
import net.mehvahdjukaar.amendments.client.particles.BoilingParticle;
import net.mehvahdjukaar.amendments.client.particles.ColoredSplashParticle;
import net.mehvahdjukaar.amendments.client.renderers.CandleSkullBlockTileRenderer;
import net.mehvahdjukaar.amendments.client.renderers.CeilingBannerBlockTileRenderer;
import net.mehvahdjukaar.amendments.client.renderers.DoubleSkullBlockTileRenderer;
import net.mehvahdjukaar.amendments.client.renderers.HangingSignRendererExtension;
import net.mehvahdjukaar.amendments.client.renderers.JukeboxTileRenderer;
import net.mehvahdjukaar.amendments.client.renderers.ToolHookTileRenderer;
import net.mehvahdjukaar.amendments.client.renderers.WallLanternBlockTileRenderer;
import net.mehvahdjukaar.amendments.common.block.BoilingWaterCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.fabric.AmendmentsClientImpl;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.CompatObjects;
import net.mehvahdjukaar.amendments.integration.FlywheelCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1813;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3929;
import net.minecraft.class_4719;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_901;

public class AmendmentsClient {
    public static final class_2960 SIGN_SHEET = new class_2960("textures/atlas/signs.png");
    public static final class_4730 CANVAS_SIGH_MATERIAL = new class_4730(SIGN_SHEET, Amendments.res("entity/signs/hanging/farmersdelight/extension_canvas"));
    public static final Supplier<Map<class_4719, class_4730>> HANGING_SIGN_EXTENSIONS = Suppliers.memoize(() -> class_4719.method_24026().collect(Collectors.toMap(Function.identity(), w -> {
        Object str = w.comp_1299();
        str = ((String)str).contains(":") ? ((String)str).replace(":", "/extension_") : "extension_" + (String)str;
        return new class_4730(SIGN_SHEET, Amendments.res("entity/signs/hanging/" + (String)str));
    }, (v1, v2) -> v1, IdentityHashMap::new)));
    private static final Map<class_1792, class_4730> RECORD_MATERIALS = new HashMap<class_1792, class_4730>();
    public static final class_4730 DEFAULT_RECORD = new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_template"));
    public static final class_4730 TINTED_RECORD = new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_tinted"));
    public static final List<class_4730> RECORD_PATTERNS = List.of(new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_0")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_1")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_2")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_3")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_4")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_5")));
    public static final List<class_4730> RECORD_PATTERNS_OVERLAY = List.of(new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_0s")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_1s")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_2s")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_3s")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_4s")), new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/music_disc_pattern_5s")));
    public static final class_5601 HANGING_SIGN_EXTENSION = AmendmentsClient.loc("hanging_sign_extension");
    public static final class_5601 HANGING_SIGN_EXTENSION_CHAINS = AmendmentsClient.loc("hanging_sign_chains");
    public static final class_5601 SKULL_CANDLE_OVERLAY = AmendmentsClient.loc("skull_candle");
    public static final class_2960 BELL_ROPE = Amendments.res("block/bell_rope");
    public static final class_2960 BELL_CHAIN = Amendments.res("block/bell_chain");
    public static final class_2960 LECTERN_GUI = Amendments.res("textures/gui/lectern.png");
    public static final class_2960 POTION_TEXTURE = Amendments.res("block/potion_cauldron");
    public static final class_2960 MUSHROOM_STEW = Amendments.res("block/mushroom_stew_cauldron");
    public static final class_2960 RABBIT_STEW = Amendments.res("block/rabbit_stew_cauldron");
    public static final class_2960 BEETROOT_SOUP = Amendments.res("block/beetroot_soup_cauldron");
    public static final class_2960 SUS_STEW = Amendments.res("block/suspicious_stew_cauldron");
    public static float x;
    public static float y;
    public static float z;
    public static final Supplier<Map<class_2248, class_2960>> SKULL_CANDLES_TEXTURES;
    private static final class_2350[] DIRS;

    private static class_5601 loc(String name) {
        return new class_5601(Amendments.res(name), name);
    }

    public static void init() {
        new ClientResourceGenerator().register();
        ClientHelper.addClientSetup(AmendmentsClient::setup);
        ClientHelper.addBlockEntityRenderersRegistration(AmendmentsClient::registerTileRenderers);
        ClientHelper.addModelLoaderRegistration(AmendmentsClient::registerModelLoaders);
        ClientHelper.addBlockColorsRegistration(AmendmentsClient::registerBlockColors);
        ClientHelper.addModelLayerRegistration(AmendmentsClient::registerModelLayers);
        ClientHelper.addSpecialModelRegistration(AmendmentsClient::registerSpecialModels);
        ClientHelper.addEntityRenderersRegistration(AmendmentsClient::registerEntityRenderers);
        ClientHelper.addItemColorsRegistration(AmendmentsClient::registerItemColors);
        ClientHelper.addParticleRegistration(AmendmentsClient::registerParticles);
        if (CompatHandler.FLYWHEEL) {
            FlywheelCompat.init();
        }
    }

    public static void setup() {
        ClientHelper.registerRenderType((class_2248)ModRegistry.CARPET_STAIRS.get(), (class_1921[])new class_1921[]{class_1921.method_23581(), class_1921.method_23577(), class_1921.method_23583()});
        ClientHelper.registerRenderType((class_2248)ModRegistry.CARPET_SLAB.get(), (class_1921[])new class_1921[]{class_1921.method_23581(), class_1921.method_23577(), class_1921.method_23583()});
        ClientHelper.registerRenderType((class_2248)ModRegistry.WATERLILY_BLOCK.get(), (class_1921)class_1921.method_23581());
        ClientHelper.registerRenderType((class_2248)class_2246.field_27097, (class_1921[])new class_1921[]{class_1921.method_23581(), class_1921.method_23583()});
        ClientHelper.registerRenderType((class_2248)((class_2248)ModRegistry.LIQUID_CAULDRON.get()), (class_1921[])new class_1921[]{class_1921.method_23581(), class_1921.method_23583()});
        ClientHelper.registerRenderType((class_2248)ModRegistry.DYE_CAULDRON.get(), (class_1921[])new class_1921[]{class_1921.method_23581(), class_1921.method_23583()});
        ClientHelper.registerRenderType((class_2248)ModRegistry.HANGING_FLOWER_POT.get(), (class_1921)class_1921.method_23581());
        ClientHelper.registerRenderType((class_2248)((class_2248)ModRegistry.WALL_LANTERN.get()), (class_1921)class_1921.method_23581());
        ClientHelper.registerRenderType((class_2248)ModRegistry.TOOL_HOOK.get(), (class_1921)class_1921.method_23581());
        class_3929.method_17542(ModRegistry.LECTERN_EDIT_MENU.get(), LecternBookEditScreen::new);
    }

    public static void afterTagSetup() {
        ItemHoldingAnimationsManager.addAnimations();
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        event.register((itemStack, i) -> i > 0 ? -1 : DyeBottleItem.getColor(itemStack), new class_1935[]{(class_1935)ModRegistry.DYE_BOTTLE_ITEM.get()});
        event.register((class_326)new CrossbowColor(), new class_1935[]{class_1802.field_8399});
    }

    private static void registerTileRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(class_2591.field_11907, JukeboxTileRenderer::new);
        event.register(ModRegistry.CEILING_BANNER_TILE.get(), CeilingBannerBlockTileRenderer::new);
        event.register(ModRegistry.SKULL_PILE_TILE.get(), DoubleSkullBlockTileRenderer::new);
        event.register(ModRegistry.SKULL_CANDLE_TILE.get(), CandleSkullBlockTileRenderer::new);
        event.register(ModRegistry.WALL_LANTERN_TILE.get(), WallLanternBlockTileRenderer::new);
        event.register(ModRegistry.TOOL_HOOK_TILE.get(), ToolHookTileRenderer::new);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((class_2396)((class_2400)ModRegistry.BOILING_PARTICLE.get()), BoilingParticle.Provider::new);
        event.register((class_2396)((class_2400)ModRegistry.SPLASH_PARTICLE.get()), ColoredSplashParticle.Provider::new);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModRegistry.FALLING_LANTERN.get(), class_901::new);
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        WallLanternModelsManager.registerSpecialModels(event);
        event.register(BELL_CHAIN);
        if (CompatHandler.SUPPLEMENTARIES) {
            event.register(BELL_ROPE);
        }
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(Amendments.res("carpet_overlay"), (CustomModelLoader)new NestedModelLoader("carpet", CarpetedBlockModel::new));
        event.register(Amendments.res("waterlogged_lily"), WaterloggedLilyModel::new);
        event.register(Amendments.res("wall_lantern"), (CustomModelLoader)new NestedModelLoader("support", WallLanternBakedModel::new));
        event.register(Amendments.res("cauldron"), (CustomModelLoader)new CauldronModelLoader());
        event.register(Amendments.res("hanging_pot"), (CustomModelLoader)new NestedModelLoader("rope", HangingPotBakedModel::new));
        event.register(Amendments.res("tool_hook"), (CustomModelLoader)new NestedModelLoader("hook", ToolHookBakedModel::new));
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(HANGING_SIGN_EXTENSION, HangingSignRendererExtension::createMesh);
        event.register(HANGING_SIGN_EXTENSION_CHAINS, HangingSignRendererExtension::createChainMesh);
        event.register(SKULL_CANDLE_OVERLAY, SkullCandleOverlayModel::createMesh);
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        ArrayList<Object> mimics = new ArrayList<Object>();
        mimics.addAll(List.of(ModRegistry.CARPET_STAIRS.get(), ModRegistry.CARPET_SLAB.get(), (class_2248)ModRegistry.WALL_LANTERN.get(), ModRegistry.HANGING_FLOWER_POT.get(), ModRegistry.WATERLILY_BLOCK.get()));
        mimics.addAll(ModRegistry.DOUBLE_CAKES.values());
        event.register((class_322)new MimicBlockColor(), mimics.toArray(new class_2248[0]));
        event.register(BoilingWaterCauldronBlock::getWaterColor, new class_2248[]{class_2246.field_27097});
        event.register((class_322)new BrewingStandColor(), new class_2248[]{class_2246.field_10333});
        event.register((class_322)new SoftFluidColor(), new class_2248[]{ModRegistry.DYE_CAULDRON.get(), (class_2248)ModRegistry.LIQUID_CAULDRON.get()});
    }

    public static Map<class_1792, class_4730> getAllRecords() {
        if (RECORD_MATERIALS.isEmpty()) {
            for (class_1792 i : class_7923.field_41178) {
                if (!(i instanceof class_1813)) continue;
                RECORD_MATERIALS.put(i, new class_4730(class_1059.field_5275, Amendments.res("block/music_discs/" + Utils.getID((class_1792)i).toString().replace("minecraft:", "").replace(":", "/"))));
            }
        }
        return RECORD_MATERIALS;
    }

    public static class_4730 getRecordMaterial(class_1792 item) {
        return AmendmentsClient.getAllRecords().getOrDefault(item, DEFAULT_RECORD);
    }

    public static void onItemTooltip(class_1799 itemStack, class_1836 tooltipFlag, List<class_2561> components) {
        if (ClientConfigs.TOOLTIP_HINTS.get().booleanValue()) {
            // empty if block
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasFixedNormals() {
        return AmendmentsClientImpl.hasFixedNormals();
    }

    @Deprecated(forRemoval=true)
    public static List<class_777> getAllModelQuads(class_1087 model, class_2680 state, class_5819 rand) {
        ArrayList<class_777> allQuads = new ArrayList<class_777>();
        for (class_2350 d : DIRS) {
            allQuads.addAll(model.method_4707(state, d, rand));
        }
        return allQuads;
    }

    static {
        SKULL_CANDLES_TEXTURES = Suppliers.memoize(() -> {
            LinkedHashMap<class_2248, class_2960> map = new LinkedHashMap<class_2248, class_2960>();
            map.put(class_2246.field_27099, Amendments.res("textures/block/skull_candles/default.png"));
            for (class_1767 color : class_1767.values()) {
                class_2248 candle = BlocksColorAPI.getColoredBlock((String)"candle", (class_1767)color);
                map.put(candle, Amendments.res("textures/block/skull_candles/" + color.method_7792() + ".png"));
            }
            if (CompatObjects.SOUL_CANDLE.get() != null) {
                map.put(CompatObjects.SOUL_CANDLE.get(), Amendments.res("textures/block/skull_candles/soul.png"));
            }
            if (CompatObjects.CUPRIC_CANDLE.get() != null) {
                map.put(CompatObjects.CUPRIC_CANDLE.get(), Amendments.res("textures/block/skull_candles/cupric.png"));
            }
            if (CompatObjects.ENDER_CANDLE.get() != null) {
                map.put(CompatObjects.ENDER_CANDLE.get(), Amendments.res("textures/block/skull_candles/ender.png"));
            }
            if (CompatObjects.SPECTACLE_CANDLE.get() != null) {
                map.put(CompatObjects.SPECTACLE_CANDLE.get(), Amendments.res("textures/block/skull_candles/spectacle.png"));
            }
            return map;
        });
        DIRS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, null};
    }
}

