/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity.breeding;

import com.google.gson.internal.LinkedTreeMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.chococraft.Chococraft;
import net.chococraft.ChococraftExpectPlatform;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;

public class BreedingHelper {
    public static ChocoboColor getColor(AbstractChocobo firstParent, AbstractChocobo secondParent) {
        ChocoboColor firstColor = firstParent.getChocoboColor();
        ChocoboColor secondColor = secondParent.getChocoboColor();
        int randColor = firstParent.method_6051().method_43048(100);
        boolean bothParentsFedGold = firstParent.isFedGoldGysahl() && secondParent.isFedGoldGysahl();
        LinkedTreeMap<String, LinkedTreeMap<String, List<LinkedTreeMap<String, String>>>> breedingInfoHashmap = ChococraftExpectPlatform.getBreedingInfoMap();
        if (breedingInfoHashmap.isEmpty()) {
            Chococraft.LOGGER.error("BreedingInfoHashmap is empty!, make sure you have a valid breeding config file!");
        }
        if (!breedingInfoHashmap.isEmpty() && breedingInfoHashmap.containsKey((Object)firstColor.name())) {
            LinkedTreeMap secondParentColorMaps = (LinkedTreeMap)breedingInfoHashmap.get((Object)firstColor.name());
            for (Map.Entry secondParentColorEntry : secondParentColorMaps.entrySet()) {
                if (!((String)secondParentColorEntry.getKey()).contains(secondColor.name())) continue;
                List breedingInfoList = (List)secondParentColorEntry.getValue();
                boolean flag = false;
                for (LinkedTreeMap breedingInfo : breedingInfoList) {
                    String[] parts;
                    String childColor = (String)breedingInfo.get((Object)"childColor");
                    String conditions = (String)breedingInfo.get((Object)"conditions");
                    String random = (String)breedingInfo.get((Object)"random");
                    if (!conditions.equals("none")) {
                        if (conditions.equals("bothParentsFedGold")) {
                            flag = true;
                            if (!bothParentsFedGold) {
                                continue;
                            }
                        } else if (conditions.equals("bothParentsNotFedGold")) {
                            flag = true;
                            if (bothParentsFedGold) {
                                continue;
                            }
                        }
                    } else if (flag && bothParentsFedGold) continue;
                    if (!random.equals("none") && (!(parts = random.split(Pattern.quote(" ")))[0].equals("above") ? parts[0].equals("under") && randColor >= Integer.parseInt(parts[1]) : randColor <= Integer.parseInt(parts[1]))) continue;
                    if (childColor.equals("secondParent")) {
                        return secondColor;
                    }
                    return ChocoboColor.valueOf(childColor);
                }
            }
        } else {
            Chococraft.LOGGER.error("Breeding Config does not contain {}", (Object)firstColor.name());
        }
        return ChocoboColor.YELLOW;
    }
}

