/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.IsInsideStructureTracker;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class InsideStructureTagCondition
implements Condition {
    public static final Codec<InsideStructureTagCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_6862.method_40090((class_5321)class_7924.field_41246).listOf().fieldOf("structure_tag_is").forGetter(insideStructureTagCondition -> insideStructureTagCondition.structureTags), (App)Codec.BOOL.optionalFieldOf("in_piece", (Object)false).forGetter(insideStructureTagCondition -> insideStructureTagCondition.intersectsPiece)).apply((Applicative)builder, InsideStructureTagCondition::new));
    private final List<class_6862<class_3195>> structureTags;
    private final boolean intersectsPiece;

    public InsideStructureTagCondition(List<class_6862<class_3195>> structureTags, boolean mustIntersectPiece) {
        if (structureTags.isEmpty()) {
            throw new IllegalArgumentException("No structures were specified.");
        }
        this.structureTags = structureTags;
        this.intersectsPiece = mustIntersectPiece;
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        class_1937 world = conditionContext.world();
        class_1309 entity = conditionContext.entity();
        if (world.field_9236) {
            return this.clientPasses((IsInsideStructureTracker.Access)entity);
        }
        class_2378 configuredStructureFeatures = world.method_30349().method_30530(class_7924.field_41246);
        for (class_6862<class_3195> structureTag : this.structureTags) {
            class_6885.class_6888 tag = configuredStructureFeatures.method_40260(structureTag);
            List structures = tag.method_40239().toList();
            for (class_6880 structure : structures) {
                class_2338 entityPosition = entity.method_24515();
                Optional possibleStructureStart = ((class_3218)world).method_27056().method_38853(class_4076.method_18682((class_2338)entityPosition), (class_3195)structure.comp_349()).stream().findFirst();
                if (possibleStructureStart.isEmpty()) {
                    return false;
                }
                class_3449 structureStart = (class_3449)possibleStructureStart.get();
                if (this.intersectsPiece) {
                    for (class_3443 piece : structureStart.method_14963()) {
                        if (piece.method_14935().method_14662((class_2382)entityPosition)) {
                            ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (class_1297)entity, new IsInsideStructureTracker.IsInside(true, true));
                            return true;
                        }
                        ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (class_1297)entity, new IsInsideStructureTracker.IsInside(structureStart.method_14969().method_14662((class_2382)entityPosition), false));
                    }
                    continue;
                }
                if (structureStart.method_14969().method_14662((class_2382)entityPosition)) {
                    ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (class_1297)entity, new IsInsideStructureTracker.IsInside(true, false));
                    return true;
                }
                ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (class_1297)entity, new IsInsideStructureTracker.IsInside(false, true));
            }
        }
        return false;
    }

    private boolean clientPasses(IsInsideStructureTracker.Access entity) {
        IsInsideStructureTracker.IsInside tracker = entity.getIsInsideStructureTracker().getTracker();
        return tracker.isInsideStructurePiece() && this.intersectsPiece || tracker.isInsideStructure();
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

