/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import mjson.Json;
import net.fabricmc.installer.client.ProfileInstaller;
import net.fabricmc.installer.util.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class VanillaLauncherIntegration {
    public static boolean installToLauncher(Component parent, Path vanillaGameDir, Path instanceDir, Path modsFolder, String profileName, String gameVersion, String loaderName, String loaderVersion, Icon icon) throws IOException {
        ProfileInstaller.LauncherType launcherType;
        String versionId = String.format("%s-%s-%s", loaderName, loaderVersion, gameVersion);
        ProfileInstaller.LauncherType launcherType2 = launcherType = System.getProperty("os.name").contains("Windows") ? VanillaLauncherIntegration.getLauncherType(vanillaGameDir) : ProfileInstaller.LauncherType.WIN32;
        if (launcherType == null) {
            return false;
        }
        VanillaLauncherIntegration.installVersion(vanillaGameDir, modsFolder, gameVersion, loaderName, loaderVersion, launcherType);
        VanillaLauncherIntegration.installProfile(parent, vanillaGameDir, instanceDir, profileName, versionId, icon, launcherType);
        return true;
    }

    public static void installVersion(Path mcDir, Path modsFolder, String gameVersion, String loaderName, String loaderVersion, ProfileInstaller.LauncherType launcherType) throws IOException {
        System.out.println("Installing " + gameVersion + " with fabric " + loaderVersion + " to launcher " + (Object)((Object)launcherType));
        String versionId = String.format("%s-%s-%s", loaderName, loaderVersion, gameVersion);
        Path versionsDir = mcDir.resolve("versions");
        Path profileDir = versionsDir.resolve(versionId);
        Path profileJsonPath = profileDir.resolve(versionId + ".json");
        if (!Files.exists(profileDir, new LinkOption[0])) {
            Files.createDirectories(profileDir, new FileAttribute[0]);
        }
        Path dummyJar = profileDir.resolve(versionId + ".jar");
        Files.deleteIfExists(dummyJar);
        Files.createFile(dummyJar, new FileAttribute[0]);
        URL profileUrl = new URL("https://meta.fabricmc.net/" + String.format("v2/versions/loader/%s/%s/profile/json", gameVersion, loaderVersion));
        Json profileJson = Json.read(profileUrl);
        if (loaderName.equals("iris-fabric-loader")) {
            VanillaLauncherIntegration.editVersionJson(profileJson, modsFolder);
        }
        Utils.writeToFile(profileJsonPath, profileJson.toString());
    }

    private static void editVersionJson(Json profileJson, Path modsFolder) {
        Json.Factory factory = Json.factory();
        Map<String, Json> json = profileJson.asJsonMap();
        json.compute("id", (ignored, existing) -> factory.string("iris-" + existing.asString()));
        json.getOrDefault("arguments", Json.array()).asJsonMap().getOrDefault("jvm", Json.array()).asJsonList().add(factory.string("-Dfabric.modsFolder=" + modsFolder.toAbsolutePath().toString()));
    }

    private static void installProfile(Component parent, Path mcDir, Path instanceDir, String profileName, String versionId, Icon icon, ProfileInstaller.LauncherType launcherType) throws IOException {
        Path launcherProfiles = mcDir.resolve(launcherType.profileJsonName);
        if (!Files.exists(launcherProfiles, new LinkOption[0])) {
            System.out.println("Could not find launcher_profiles");
            return;
        }
        System.out.println("Creating profile");
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(Utils.readString(launcherProfiles));
        }
        catch (JSONException e) {
            JOptionPane.showMessageDialog(parent, "Failed to add profile, you might not have logged into the launcher.");
            return;
        }
        JSONObject profiles = jsonObject.getJSONObject("profiles");
        String foundProfileName = profileName;
        Iterator<String> it = profiles.keys();
        while (it.hasNext()) {
            String key = it.next();
            JSONObject foundProfile = profiles.getJSONObject(key);
            if (!foundProfile.has("lastVersionId") || !foundProfile.getString("lastVersionId").equals(versionId) || !foundProfile.has("gameDir") || !foundProfile.getString("gameDir").equals(instanceDir.toString())) continue;
            foundProfileName = key;
        }
        JSONObject profile = profiles.has(foundProfileName) ? profiles.getJSONObject(foundProfileName) : VanillaLauncherIntegration.createProfile(profileName, instanceDir, versionId, icon);
        profile.put("name", profileName);
        profile.put("lastUsed", Utils.ISO_8601.format(new Date()));
        profile.put("lastVersionId", versionId);
        profiles.put(foundProfileName, profile);
        jsonObject.put("profiles", profiles);
        Utils.writeToFile(launcherProfiles, jsonObject.toString());
    }

    private static JSONObject createProfile(String name, Path instanceDir, String versionId, Icon icon) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", name);
        jsonObject.put("type", "custom");
        jsonObject.put("created", Utils.ISO_8601.format(new Date()));
        jsonObject.put("gameDir", instanceDir.toString());
        jsonObject.put("lastUsed", Utils.ISO_8601.format(new Date()));
        jsonObject.put("lastVersionId", versionId);
        jsonObject.put("icon", VanillaLauncherIntegration.getProfileIcon(icon));
        return jsonObject;
    }

    private static String getProfileIcon(Icon icon) {
        if (icon == Icon.FABRIC) {
            return Utils.getProfileIcon();
        }
        try {
            String var4;
            try (InputStream is = Utils.class.getClassLoader().getResourceAsStream("iris_profile_icon.png");){
                int len;
                byte[] ret = new byte[4096];
                int offset = 0;
                while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                    if ((offset += len) != ret.length) continue;
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                var4 = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
            }
            return var4;
        }
        catch (IOException var7) {
            var7.printStackTrace();
            return "TNT";
        }
    }

    private static ProfileInstaller.LauncherType showLauncherTypeSelection() {
        Object[] options = new String[]{Utils.BUNDLE.getString("prompt.launcher.type.xbox"), Utils.BUNDLE.getString("prompt.launcher.type.win32")};
        int result = JOptionPane.showOptionDialog(null, Utils.BUNDLE.getString("prompt.launcher.type.body"), Utils.BUNDLE.getString("installer.title"), 1, 3, null, options, options[0]);
        if (result == -1) {
            return null;
        }
        return result == 0 ? ProfileInstaller.LauncherType.MICROSOFT_STORE : ProfileInstaller.LauncherType.WIN32;
    }

    public static ProfileInstaller.LauncherType getLauncherType(Path vanillaGameDir) {
        ProfileInstaller.LauncherType launcherType;
        List<ProfileInstaller.LauncherType> types = VanillaLauncherIntegration.getInstalledLauncherTypes(vanillaGameDir);
        if (types.size() == 0) {
            System.out.println("No launchers found, profile installation will not take place!");
            launcherType = ProfileInstaller.LauncherType.WIN32;
        } else if (types.size() == 1) {
            System.out.println("Found only one launcher (" + (Object)((Object)types.get(0)) + "), will proceed with that!");
            launcherType = types.get(0);
        } else {
            System.out.println("Multiple launchers found, showing selection screen!");
            launcherType = VanillaLauncherIntegration.showLauncherTypeSelection();
            if (launcherType == null) {
                System.out.println(Utils.BUNDLE.getString("prompt.ready.install"));
                launcherType = ProfileInstaller.LauncherType.WIN32;
            }
        }
        return launcherType;
    }

    public static List<ProfileInstaller.LauncherType> getInstalledLauncherTypes(Path mcDir) {
        return Arrays.stream(ProfileInstaller.LauncherType.values()).filter(launcherType -> Files.exists(mcDir.resolve(launcherType.profileJsonName), new LinkOption[0])).collect(Collectors.toList());
    }

    public static enum Icon {
        IRIS,
        FABRIC;

    }
}

